/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.receiver.internals;

import java.util.Collections;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import reactor.kafka.receiver.ReceiverPartition;

class SeekablePartition
implements ReceiverPartition {
    private final Consumer<?, ?> consumer;
    private final TopicPartition topicPartition;

    public SeekablePartition(Consumer<?, ?> consumer, TopicPartition topicPartition) {
        this.consumer = consumer;
        this.topicPartition = topicPartition;
    }

    @Override
    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    public void seekToBeginning() {
        this.consumer.seekToBeginning(Collections.singletonList(this.topicPartition));
    }

    @Override
    public void seekToEnd() {
        this.consumer.seekToEnd(Collections.singletonList(this.topicPartition));
    }

    @Override
    public void seek(long offset) {
        this.consumer.seek(this.topicPartition, offset);
    }

    @Override
    public long position() {
        return this.consumer.position(this.topicPartition);
    }

    public String toString() {
        return String.valueOf(this.topicPartition);
    }
}

