/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.brave;

import brave.Span;
import brave.SpanCustomizer;
import brave.http.HttpServerHandler;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.netty.channel.EventLoop;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerState;
import reactor.util.annotation.Nullable;

final class TracingHttpServerDecorator {
    final CurrentTraceContext currentTraceContext;
    final HttpServerHandler<brave.http.HttpServerRequest, HttpServerResponse> handler;
    final Function<String, String> uriMapping;
    static final AttributeKey<brave.http.HttpServerRequest> REQUEST_ATTR_KEY = AttributeKey.newInstance((String)HttpServerResponse.class.getName());
    static final AttributeKey<Span> SPAN_ATTR_KEY = AttributeKey.newInstance((String)Span.class.getName());

    TracingHttpServerDecorator(HttpTracing httpTracing, Function<String, String> uriMapping) {
        Objects.requireNonNull(httpTracing, "httpTracing");
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing);
        this.uriMapping = Objects.requireNonNull(uriMapping, "uriMapping");
    }

    HttpServer decorate(HttpServer server) {
        return ((HttpServer)server.childObserve((ConnectionObserver)new TracingConnectionObserver(this.currentTraceContext, this.handler, this.uriMapping))).mapHandle((BiFunction)new TracingMapHandle(this.currentTraceContext, this.handler));
    }

    static final class TracingMapHandle
    implements BiFunction<Mono<Void>, Connection, Mono<Void>> {
        final CurrentTraceContext currentTraceContext;
        final HttpServerHandler<brave.http.HttpServerRequest, HttpServerResponse> handler;
        volatile Throwable throwable;

        TracingMapHandle(CurrentTraceContext currentTraceContext, HttpServerHandler<brave.http.HttpServerRequest, HttpServerResponse> handler) {
            this.currentTraceContext = currentTraceContext;
            this.handler = handler;
        }

        @Override
        public Mono<Void> apply(Mono<Void> voidMono, Connection connection) {
            brave.http.HttpServerRequest braveRequest = (brave.http.HttpServerRequest)connection.channel().attr(REQUEST_ATTR_KEY).get();
            Span span = (Span)connection.channel().attr(SPAN_ATTR_KEY).get();
            return voidMono.doFinally(sig -> {
                if (braveRequest.unwrap() instanceof reactor.netty.http.server.HttpServerResponse) {
                    reactor.netty.http.server.HttpServerResponse response = (reactor.netty.http.server.HttpServerResponse)braveRequest.unwrap();
                    Span localSpan = sig == SignalType.CANCEL ? span.annotate("cancel") : span;
                    DelegatingHttpResponse braveResponse = new DelegatingHttpResponse(response, braveRequest, this.throwable);
                    response.withConnection(conn -> {
                        EventLoop eventLoop = conn.channel().eventLoop();
                        if (eventLoop.inEventLoop()) {
                            this.handler.handleSend(braveResponse, localSpan);
                        } else {
                            eventLoop.execute(() -> this.handler.handleSend(braveResponse, localSpan));
                        }
                    });
                    connection.channel().attr(REQUEST_ATTR_KEY).set(null);
                    connection.channel().attr(SPAN_ATTR_KEY).set(null);
                }
            }).doOnError(this::throwable).contextWrite(ctx -> ctx.put(TraceContext.class, (Object)span.context()).put(SpanCustomizer.class, (Object)span.customizer()));
        }

        void throwable(Throwable t) {
            this.throwable = t;
        }
    }

    static final class TracingConnectionObserver
    implements ConnectionObserver {
        final CurrentTraceContext currentTraceContext;
        final HttpServerHandler<brave.http.HttpServerRequest, HttpServerResponse> handler;
        final Function<String, String> uriMapping;

        TracingConnectionObserver(CurrentTraceContext currentTraceContext, HttpServerHandler<brave.http.HttpServerRequest, HttpServerResponse> handler, Function<String, String> uriMapping) {
            this.currentTraceContext = currentTraceContext;
            this.handler = handler;
            this.uriMapping = uriMapping;
        }

        public void onStateChange(Connection connection, ConnectionObserver.State state) {
            if (state == ConnectionObserver.State.CONFIGURED && connection instanceof HttpServerRequest) {
                HttpServerRequest request = (HttpServerRequest)connection;
                DelegatingHttpRequest braveRequest = new DelegatingHttpRequest(request, this.uriMapping);
                Span span = this.handler.handleReceive((brave.http.HttpServerRequest)braveRequest);
                connection.channel().attr(REQUEST_ATTR_KEY).set((Object)braveRequest);
                connection.channel().attr(SPAN_ATTR_KEY).set((Object)span);
                return;
            }
            if (state == HttpServerState.REQUEST_DECODING_FAILED && connection instanceof reactor.netty.http.server.HttpServerResponse) {
                Span span;
                reactor.netty.http.server.HttpServerResponse response = (reactor.netty.http.server.HttpServerResponse)connection;
                brave.http.HttpServerRequest braveRequest = (brave.http.HttpServerRequest)connection.channel().attr(REQUEST_ATTR_KEY).getAndSet(null);
                if (braveRequest == null && connection instanceof HttpServerRequest) {
                    braveRequest = new DelegatingHttpRequest((HttpServerRequest)connection, this.uriMapping);
                }
                if ((span = (Span)connection.channel().attr(SPAN_ATTR_KEY).getAndSet(null)) == null) {
                    span = this.handler.handleReceive(braveRequest);
                }
                this.handler.handleSend((HttpServerResponse)new DelegatingHttpResponse(response, braveRequest), span);
            }
        }

        public void onUncaughtException(Connection connection, Throwable error) {
            Span span = (Span)connection.channel().attr(SPAN_ATTR_KEY).getAndSet(null);
            if (span != null) {
                span.error(error).finish();
            }
        }
    }

    static final class DelegatingHttpResponse
    extends HttpServerResponse {
        final reactor.netty.http.server.HttpServerResponse delegate;
        final brave.http.HttpServerRequest request;
        final Throwable error;

        DelegatingHttpResponse(reactor.netty.http.server.HttpServerResponse delegate, @Nullable brave.http.HttpServerRequest request) {
            this(delegate, request, null);
        }

        DelegatingHttpResponse(reactor.netty.http.server.HttpServerResponse delegate, @Nullable brave.http.HttpServerRequest request, @Nullable Throwable error) {
            this.delegate = delegate;
            this.request = request;
            this.error = error;
        }

        @Nullable
        public brave.http.HttpServerRequest request() {
            return this.request;
        }

        @Nullable
        public Throwable error() {
            return this.error;
        }

        public int statusCode() {
            return this.delegate.status().code();
        }

        public Object unwrap() {
            return this.delegate;
        }
    }

    static final class DelegatingHttpRequest
    extends brave.http.HttpServerRequest {
        final HttpServerRequest delegate;
        final Function<String, String> uriMapping;
        final String path;
        static final Pattern SCHEME_PATTERN = Pattern.compile("^(https?|wss?)://.*$");

        DelegatingHttpRequest(HttpServerRequest delegate, Function<String, String> uriMapping) {
            this.delegate = delegate;
            this.uriMapping = uriMapping;
            this.path = this.initPath();
        }

        @Nullable
        String initPath() {
            try {
                return this.delegate.fullPath();
            }
            catch (IllegalStateException e) {
                return null;
            }
        }

        @Nullable
        public String header(String name) {
            Objects.requireNonNull(name, "name");
            return this.delegate.requestHeaders().get(name);
        }

        public String method() {
            return this.delegate.method().name();
        }

        public boolean parseClientIpAndPort(Span span) {
            Objects.requireNonNull(span, "span");
            InetSocketAddress remoteAddress = this.delegate.remoteAddress();
            if (remoteAddress == null) {
                return false;
            }
            return span.remoteIpAndPort(remoteAddress.getHostString(), remoteAddress.getPort());
        }

        @Nullable
        public String path() {
            return this.path;
        }

        @Nullable
        public String route() {
            return this.path == null ? null : this.uriMapping.apply(this.path);
        }

        public Object unwrap() {
            return this.delegate;
        }

        @Nullable
        public String url() {
            InetSocketAddress hostAddress = this.delegate.hostAddress();
            if (hostAddress == null) {
                return null;
            }
            String tempUri = this.delegate.uri();
            if (tempUri.isEmpty() || tempUri.charAt(0) == '/') {
                tempUri = this.delegate.scheme() + "://" + hostAddress.getHostString() + ":" + hostAddress.getPort() + tempUri;
            } else if (!SCHEME_PATTERN.matcher(tempUri).matches()) {
                tempUri = this.delegate.scheme() + "://" + tempUri;
            }
            return tempUri;
        }
    }
}

