/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.brave;

import brave.Span;
import brave.SpanCustomizer;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.netty.ChannelPipelineConfigurer;
import reactor.netty.Connection;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.brave.ReactorNettyHttpTracing;
import reactor.netty.http.brave.TracingChannelPipelineConfigurer;
import reactor.netty.http.client.HttpClient;
import reactor.util.annotation.Nullable;
import reactor.util.context.ContextView;

final class TracingHttpClientDecorator {
    final CurrentTraceContext currentTraceContext;
    final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;
    final Function<String, String> uriMapping;

    TracingHttpClientDecorator(HttpTracing httpTracing, Function<String, String> uriMapping) {
        Objects.requireNonNull(httpTracing, "httpTracing");
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
        this.uriMapping = Objects.requireNonNull(uriMapping, "uriMapping");
    }

    HttpClient decorate(HttpClient client) {
        TracingDoOnResponse onResponse = new TracingDoOnResponse(this.handler, this.uriMapping);
        return ((HttpClient)client.doOnRequest((BiConsumer)new TracingDoOnRequest(this.handler, this.uriMapping)).doOnResponse((BiConsumer)onResponse).doOnRedirect((BiConsumer)onResponse).doOnError((BiConsumer)new TracingDoOnRequestError(this.handler, this.uriMapping), (BiConsumer)new TracingDoOnResponseError(this.handler, this.uriMapping)).doOnChannelInit((ChannelPipelineConfigurer)new TracingChannelPipelineConfigurer(this.currentTraceContext))).mapConnect((Function)new TracingMapConnect(this.currentTraceContext));
    }

    static void cleanup(Channel channel) {
        EventLoop eventLoop = channel.eventLoop();
        if (eventLoop.inEventLoop()) {
            channel.attr(ReactorNettyHttpTracing.SPAN_ATTR_KEY).set(null);
        } else {
            eventLoop.execute(() -> channel.attr(ReactorNettyHttpTracing.SPAN_ATTR_KEY).set(null));
        }
    }

    static final class TracingMapConnect
    implements Function<Mono<? extends Connection>, Mono<? extends Connection>> {
        final CurrentTraceContext currentTraceContext;

        TracingMapConnect(CurrentTraceContext currentTraceContext) {
            this.currentTraceContext = currentTraceContext;
        }

        @Override
        public Mono<? extends Connection> apply(Mono<? extends Connection> mono) {
            PendingSpan pendingSpan = new PendingSpan();
            return mono.doOnCancel(() -> {
                Span span = pendingSpan.getAndSet(null);
                if (span != null) {
                    span.annotate("cancel").finish();
                }
            }).contextWrite(ctx -> {
                TraceContext invocationContext = this.currentTraceContext.get();
                if (invocationContext != null) {
                    ctx = ctx.put(TraceContext.class, (Object)invocationContext);
                }
                return ctx.put(PendingSpan.class, (Object)pendingSpan).put((Object)SpanCustomizer.class.getName(), new AtomicReference());
            });
        }
    }

    static final class TracingDoOnResponse
    extends AbstractTracingDoOnHandler
    implements BiConsumer<reactor.netty.http.client.HttpClientResponse, Connection> {
        final Function<String, String> uriMapping;

        TracingDoOnResponse(HttpClientHandler<HttpClientRequest, HttpClientResponse> handler, Function<String, String> uriMapping) {
            super(handler);
            this.uriMapping = uriMapping;
        }

        @Override
        public void accept(reactor.netty.http.client.HttpClientResponse response, Connection connection) {
            DelegatingHttpResponse delegate = new DelegatingHttpResponse(response, new DelegatingHttpRequest((reactor.netty.http.client.HttpClientRequest)response, this.uriMapping), null);
            this.handleReceive(delegate, response.currentContextView());
            TracingHttpClientDecorator.cleanup(((ChannelOperations)response).channel());
        }
    }

    static final class TracingDoOnResponseError
    extends AbstractTracingDoOnHandler
    implements BiConsumer<reactor.netty.http.client.HttpClientResponse, Throwable> {
        final Function<String, String> uriMapping;

        TracingDoOnResponseError(HttpClientHandler<HttpClientRequest, HttpClientResponse> handler, Function<String, String> uriMapping) {
            super(handler);
            this.uriMapping = uriMapping;
        }

        @Override
        public void accept(reactor.netty.http.client.HttpClientResponse response, Throwable throwable) {
            DelegatingHttpResponse delegate = new DelegatingHttpResponse(response, new DelegatingHttpRequest((reactor.netty.http.client.HttpClientRequest)response, this.uriMapping), throwable);
            this.handleReceive(delegate, response.currentContextView());
            TracingHttpClientDecorator.cleanup(((ChannelOperations)response).channel());
        }
    }

    static final class TracingDoOnRequestError
    extends AbstractTracingDoOnHandler
    implements BiConsumer<reactor.netty.http.client.HttpClientRequest, Throwable> {
        final Function<String, String> uriMapping;

        TracingDoOnRequestError(HttpClientHandler<HttpClientRequest, HttpClientResponse> handler, Function<String, String> uriMapping) {
            super(handler);
            this.uriMapping = uriMapping;
        }

        @Override
        public void accept(reactor.netty.http.client.HttpClientRequest request, Throwable throwable) {
            if (request instanceof reactor.netty.http.client.HttpClientResponse) {
                DelegatingHttpResponse delegate = new DelegatingHttpResponse((reactor.netty.http.client.HttpClientResponse)request, new DelegatingHttpRequest(request, this.uriMapping), throwable);
                this.handleReceive(delegate, request.currentContextView());
            } else {
                PendingSpan pendingSpan = (PendingSpan)request.currentContextView().get(PendingSpan.class);
                Span span = pendingSpan.getAndSet(null);
                if (span != null) {
                    span.error(throwable).finish();
                }
            }
            TracingHttpClientDecorator.cleanup(((ChannelOperations)request).channel());
        }
    }

    static final class TracingDoOnRequest
    implements BiConsumer<reactor.netty.http.client.HttpClientRequest, Connection> {
        final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;
        final Function<String, String> uriMapping;

        TracingDoOnRequest(HttpClientHandler<HttpClientRequest, HttpClientResponse> handler, Function<String, String> uriMapping) {
            this.handler = handler;
            this.uriMapping = uriMapping;
        }

        @Override
        public void accept(reactor.netty.http.client.HttpClientRequest request, Connection connection) {
            PendingSpan pendingSpan;
            Span oldSpan;
            ContextView contextView = request.currentContextView();
            TraceContext parent = (TraceContext)contextView.getOrDefault(TraceContext.class, null);
            DelegatingHttpRequest braveRequest = new DelegatingHttpRequest(request, this.uriMapping);
            Span span = this.handler.handleSendWithParent((HttpClientRequest)braveRequest, parent);
            SocketAddress remoteAddress = connection.channel().remoteAddress();
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)remoteAddress;
                span.remoteIpAndPort(address.getHostString(), address.getPort());
            }
            if ((oldSpan = (pendingSpan = (PendingSpan)contextView.get(PendingSpan.class)).getAndSet(span)) != null) {
                oldSpan.abandon();
            }
            AtomicReference ref = (AtomicReference)contextView.get((Object)SpanCustomizer.class.getName());
            ref.set(span.customizer());
            connection.channel().attr(ReactorNettyHttpTracing.SPAN_ATTR_KEY).set((Object)span);
        }
    }

    static final class PendingSpan
    extends AtomicReference<Span> {
        PendingSpan() {
        }
    }

    static final class DelegatingHttpResponse
    extends HttpClientResponse {
        final reactor.netty.http.client.HttpClientResponse delegate;
        final Throwable error;
        final HttpClientRequest request;

        DelegatingHttpResponse(reactor.netty.http.client.HttpClientResponse delegate, HttpClientRequest request, @Nullable Throwable error) {
            this.delegate = delegate;
            this.request = request;
            this.error = error;
        }

        public int statusCode() {
            try {
                return this.delegate.status().code();
            }
            catch (IllegalStateException e) {
                return 0;
            }
        }

        public Object unwrap() {
            return this.delegate;
        }

        public HttpClientRequest request() {
            return this.request;
        }

        @Nullable
        public Throwable error() {
            return this.error;
        }
    }

    static final class DelegatingHttpRequest
    extends HttpClientRequest {
        final reactor.netty.http.client.HttpClientRequest delegate;
        final Function<String, String> uriMapping;

        DelegatingHttpRequest(reactor.netty.http.client.HttpClientRequest delegate, Function<String, String> uriMapping) {
            this.delegate = delegate;
            this.uriMapping = uriMapping;
        }

        @Nullable
        public String header(String name) {
            Objects.requireNonNull(name, "name");
            return this.delegate.requestHeaders().get(name);
        }

        public void header(String name, String value) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(value, "value");
            this.delegate.header((CharSequence)name, (CharSequence)value);
        }

        public String method() {
            return this.delegate.method().name();
        }

        public String path() {
            return this.delegate.fullPath();
        }

        public String route() {
            return this.uriMapping.apply(this.path());
        }

        public Object unwrap() {
            return this.delegate;
        }

        @Nullable
        public String url() {
            return this.delegate.resourceUrl();
        }
    }

    static abstract class AbstractTracingDoOnHandler {
        final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

        AbstractTracingDoOnHandler(HttpClientHandler<HttpClientRequest, HttpClientResponse> handler) {
            this.handler = handler;
        }

        void handleReceive(HttpClientResponse response, ContextView contextView) {
            PendingSpan pendingSpan = (PendingSpan)contextView.get(PendingSpan.class);
            Span span = pendingSpan.getAndSet(null);
            if (span != null) {
                this.handler.handleReceive(response, span);
            }
        }
    }
}

