/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Queue;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.Http2Pool;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.http.client.HttpClientState;
import reactor.netty.http.client.MicrometerHttp2ConnectionProviderMeterRegistrar;
import reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import reactor.netty.internal.shaded.reactor.pool.PooledRef;
import reactor.netty.internal.shaded.reactor.pool.PooledRefMetadata;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.PooledConnectionProvider;
import reactor.netty.transport.TransportConfig;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

final class Http2ConnectionProvider
extends PooledConnectionProvider<Connection> {
    final ConnectionProvider parent;
    static final String CONNECTION_PROVIDER_NAME = "http2";
    static final String NAME_SEPARATOR = ".";
    static final Logger log = Loggers.getLogger(Http2ConnectionProvider.class);
    static final AttributeKey<ConnectionObserver> OWNER = AttributeKey.valueOf((String)"http2ConnectionOwner");

    Http2ConnectionProvider(ConnectionProvider parent) {
        super(Http2ConnectionProvider.initConfiguration(parent));
        this.parent = parent;
    }

    static ConnectionProvider.Builder initConfiguration(ConnectionProvider parent) {
        String name = parent.name() == null ? CONNECTION_PROVIDER_NAME : "http2." + parent.name();
        ConnectionProvider.Builder builder = parent.mutate();
        if (builder != null) {
            return (ConnectionProvider.Builder)builder.name(name).pendingAcquireMaxCount(-1);
        }
        return (ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)name).maxConnections(parent.maxConnections())).pendingAcquireMaxCount(-1);
    }

    protected CoreSubscriber<PooledRef<Connection>> createDisposableAcquire(TransportConfig config, ConnectionObserver connectionObserver, long pendingAcquireTimeout, InstrumentedPool<Connection> pool, MonoSink<Connection> sink) {
        boolean acceptGzip = false;
        ChannelMetricsRecorder metricsRecorder = config.metricsRecorder() != null ? (ChannelMetricsRecorder)config.metricsRecorder().get() : null;
        Function<String, String> uriTagValue = null;
        if (config instanceof HttpClientConfig) {
            acceptGzip = ((HttpClientConfig)config).acceptGzip;
            uriTagValue = ((HttpClientConfig)config).uriTagValue;
        }
        return new DisposableAcquire(connectionObserver, config.channelOperationsProvider(), acceptGzip, metricsRecorder, pendingAcquireTimeout, pool, sink, uriTagValue);
    }

    protected InstrumentedPool<Connection> createPool(TransportConfig config, PooledConnectionProvider.PoolFactory<Connection> poolFactory, SocketAddress remoteAddress, AddressResolverGroup<?> resolverGroup) {
        return new PooledConnectionAllocator((ConnectionProvider)this.parent, (TransportConfig)config, poolFactory, (Supplier<SocketAddress>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$createPool$0(java.net.SocketAddress ), ()Ljava/net/SocketAddress;)((SocketAddress)remoteAddress), resolverGroup).pool;
    }

    protected void registerDefaultMetrics(String id, SocketAddress remoteAddress, InstrumentedPool.PoolMetrics metrics) {
        MicrometerHttp2ConnectionProviderMeterRegistrar.INSTANCE.registerMetrics(this.name(), id, remoteAddress, metrics);
    }

    static void invalidate(@Nullable ConnectionObserver owner) {
        if (owner instanceof DisposableAcquire) {
            DisposableAcquire da = (DisposableAcquire)owner;
            da.pooledRef.invalidate().subscribe();
        }
    }

    static void logStreamsState(Channel channel, Http2Connection.Endpoint<Http2LocalFlowController> localEndpoint, String msg) {
        log.debug(ReactorNetty.format((Channel)channel, (String)"{}, now: {} active streams and {} max active streams."), new Object[]{msg, localEndpoint.numActiveStreams(), localEndpoint.maxActiveStreams()});
    }

    static void registerClose(Channel channel, ConnectionObserver owner) {
        channel.closeFuture().addListener(f -> {
            Http2FrameCodec frameCodec;
            if (log.isDebugEnabled() && (frameCodec = (Http2FrameCodec)channel.parent().pipeline().get(Http2FrameCodec.class)) != null) {
                Http2Connection.Endpoint localEndpoint = frameCodec.connection().local();
                Http2ConnectionProvider.logStreamsState(channel, (Http2Connection.Endpoint<Http2LocalFlowController>)localEndpoint, "Stream closed");
            }
            Http2ConnectionProvider.invalidate(owner);
        });
    }

    private static /* synthetic */ SocketAddress lambda$createPool$0(SocketAddress remoteAddress) {
        return remoteAddress;
    }

    static final class PooledConnectionAllocator {
        final ConnectionProvider parent;
        final HttpClientConfig config;
        final InstrumentedPool<Connection> pool;
        final Supplier<SocketAddress> remoteAddress;
        final AddressResolverGroup<?> resolver;
        static final BiPredicate<Connection, PooledRefMetadata> DEFAULT_EVICTION_PREDICATE = (connection, metadata) -> false;
        static final Function<Connection, Publisher<Void>> DEFAULT_DESTROY_HANDLER = connection -> Mono.empty();

        PooledConnectionAllocator(ConnectionProvider parent, TransportConfig config, PooledConnectionProvider.PoolFactory<Connection> poolFactory, Supplier<SocketAddress> remoteAddress, AddressResolverGroup<?> resolver) {
            this.parent = parent;
            this.config = (HttpClientConfig)config;
            this.remoteAddress = remoteAddress;
            this.resolver = resolver;
            this.pool = poolFactory.newPool(this.connectChannel(), null, DEFAULT_DESTROY_HANDLER, DEFAULT_EVICTION_PREDICATE, poolConFig -> new Http2Pool((PoolConfig<Connection>)poolConFig, poolFactory.maxLifeTime()));
        }

        Publisher<Connection> connectChannel() {
            return this.parent.acquire((TransportConfig)this.config, (ConnectionObserver)new DelegatingConnectionObserver(), this.remoteAddress, this.resolver).map(conn -> conn);
        }
    }

    static final class PendingConnectionObserver
    implements ConnectionObserver {
        final Queue<Pending> pendingQueue = (Queue)Queues.unbounded((int)4).get();

        PendingConnectionObserver() {
        }

        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            this.pendingQueue.add(new Pending(connection, null, newState));
        }

        public void onUncaughtException(Connection connection, Throwable error) {
            this.pendingQueue.add(new Pending(connection, error, null));
        }

        static class Pending {
            final Connection connection;
            final Throwable error;
            final ConnectionObserver.State state;

            Pending(Connection connection, @Nullable Throwable error, @Nullable ConnectionObserver.State state) {
                this.connection = connection;
                this.error = error;
                this.state = state;
            }
        }
    }

    static final class DisposableAcquire
    implements CoreSubscriber<PooledRef<Connection>>,
    ConnectionObserver,
    Disposable,
    GenericFutureListener<Future<Http2StreamChannel>> {
        final Disposable.Composite cancellations;
        final ConnectionObserver obs;
        final ChannelOperations.OnSetup opsFactory;
        final boolean acceptGzip;
        final ChannelMetricsRecorder metricsRecorder;
        final long pendingAcquireTimeout;
        final InstrumentedPool<Connection> pool;
        final boolean retried;
        final MonoSink<Connection> sink;
        final Function<String, String> uriTagValue;
        PooledRef<Connection> pooledRef;
        Subscription subscription;

        DisposableAcquire(ConnectionObserver obs, ChannelOperations.OnSetup opsFactory, boolean acceptGzip, @Nullable ChannelMetricsRecorder metricsRecorder, long pendingAcquireTimeout, InstrumentedPool<Connection> pool, MonoSink<Connection> sink, @Nullable Function<String, String> uriTagValue) {
            this.cancellations = Disposables.composite();
            this.obs = obs;
            this.opsFactory = opsFactory;
            this.acceptGzip = acceptGzip;
            this.metricsRecorder = metricsRecorder;
            this.pendingAcquireTimeout = pendingAcquireTimeout;
            this.pool = pool;
            this.retried = false;
            this.sink = sink;
            this.uriTagValue = uriTagValue;
        }

        DisposableAcquire(DisposableAcquire parent) {
            this.cancellations = parent.cancellations;
            this.obs = parent.obs;
            this.opsFactory = parent.opsFactory;
            this.acceptGzip = parent.acceptGzip;
            this.metricsRecorder = parent.metricsRecorder;
            this.pendingAcquireTimeout = parent.pendingAcquireTimeout;
            this.pool = parent.pool;
            this.retried = true;
            this.sink = parent.sink;
            this.uriTagValue = parent.uriTagValue;
        }

        public Context currentContext() {
            return this.sink.currentContext();
        }

        public void dispose() {
            this.subscription.cancel();
        }

        public void onComplete() {
        }

        public void onError(Throwable t) {
            this.sink.error(t);
        }

        public void onNext(PooledRef<Connection> pooledRef) {
            this.pooledRef = pooledRef;
            Channel channel = ((Connection)pooledRef.poolable()).channel();
            ConnectionObserver current = (ConnectionObserver)channel.attr(OWNER).getAndSet((Object)this);
            if (current instanceof PendingConnectionObserver) {
                PendingConnectionObserver.Pending p;
                PendingConnectionObserver pending = (PendingConnectionObserver)current;
                while ((p = pending.pendingQueue.poll()) != null) {
                    if (p.error != null) {
                        this.onUncaughtException(p.connection, p.error);
                        continue;
                    }
                    if (p.state == null) continue;
                    this.onStateChange(p.connection, p.state);
                }
            }
            if (this.notHttp2()) {
                return;
            }
            if (this.isH2cUpgrade()) {
                return;
            }
            HttpClientConfig.openStream(channel, this, this.obs, this.opsFactory, this.acceptGzip, this.metricsRecorder, this.uriTagValue).addListener((GenericFutureListener)this);
        }

        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == HttpClientState.UPGRADE_REJECTED) {
                Http2ConnectionProvider.invalidate((ConnectionObserver)connection.channel().attr(OWNER).get());
            }
            this.obs.onStateChange(connection, newState);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.subscription, (Subscription)s)) {
                this.subscription = s;
                this.cancellations.add((Disposable)this);
                if (!this.retried) {
                    this.sink.onCancel((Disposable)this.cancellations);
                }
                s.request(Long.MAX_VALUE);
            }
        }

        public void onUncaughtException(Connection connection, Throwable error) {
            this.obs.onUncaughtException(connection, error);
        }

        public void operationComplete(Future<Http2StreamChannel> future) {
            Channel channel = ((Connection)this.pooledRef.poolable()).channel();
            Http2FrameCodec frameCodec = (Http2FrameCodec)channel.pipeline().get(Http2FrameCodec.class);
            if (future.isSuccess()) {
                Http2StreamChannel ch = (Http2StreamChannel)future.getNow();
                if (!channel.isActive() || frameCodec == null || !frameCodec.connection().local().canOpenStream()) {
                    Http2ConnectionProvider.invalidate(this);
                    if (!this.retried) {
                        if (log.isDebugEnabled()) {
                            log.debug(ReactorNetty.format((Channel)ch, (String)"Immediately aborted pooled channel, max active streams is reached, re-acquiring a new channel"));
                        }
                        this.pool.acquire(Duration.ofMillis(this.pendingAcquireTimeout)).subscribe((CoreSubscriber)new DisposableAcquire(this));
                    } else {
                        this.sink.error((Throwable)new IOException("Error while acquiring from " + this.pool + ". Max active streams is reached."));
                    }
                } else {
                    ChannelOperations ops = ChannelOperations.get((Channel)ch);
                    if (ops != null) {
                        this.obs.onStateChange((Connection)ops, (ConnectionObserver.State)HttpClientState.STREAM_CONFIGURED);
                        this.sink.success((Object)ops);
                    }
                    Http2Connection.Endpoint localEndpoint = frameCodec.connection().local();
                    if (log.isDebugEnabled()) {
                        Http2ConnectionProvider.logStreamsState((Channel)ch, (Http2Connection.Endpoint<Http2LocalFlowController>)localEndpoint, "Stream opened");
                    }
                }
            } else {
                Http2ConnectionProvider.invalidate(this);
                this.sink.error(future.cause());
            }
        }

        boolean isH2cUpgrade() {
            ChannelOperations ops;
            Channel channel = ((Connection)this.pooledRef.poolable()).channel();
            if (channel.pipeline().get("reactor.left.h2cUpgradeHandler") != null && channel.pipeline().get("reactor.left.h2MultiplexHandler") == null && (ops = ChannelOperations.get((Channel)channel)) != null) {
                this.sink.success((Object)ops);
                return true;
            }
            return false;
        }

        boolean notHttp2() {
            ChannelOperations ops;
            Channel channel = ((Connection)this.pooledRef.poolable()).channel();
            ChannelPipeline pipeline = channel.pipeline();
            SslHandler handler = (SslHandler)pipeline.get(SslHandler.class);
            if (handler != null) {
                String protocol;
                String string = protocol = handler.applicationProtocol() != null ? handler.applicationProtocol() : "http/1.1";
                if ("http/1.1".equals(protocol)) {
                    ChannelOperations ops2 = ChannelOperations.get((Channel)channel);
                    if (ops2 != null) {
                        this.sink.success((Object)ops2);
                        Http2ConnectionProvider.invalidate(this);
                        return true;
                    }
                } else if (!"h2".equals(handler.applicationProtocol())) {
                    channel.attr(OWNER).set(null);
                    Http2ConnectionProvider.invalidate(this);
                    this.sink.error((Throwable)new IOException("Unknown protocol [" + protocol + "]."));
                    return true;
                }
            } else if (pipeline.get("reactor.left.h2cUpgradeHandler") == null && pipeline.get("reactor.left.h2MultiplexHandler") == null && (ops = ChannelOperations.get((Channel)channel)) != null) {
                this.sink.success((Object)ops);
                Http2ConnectionProvider.invalidate(this);
                return true;
            }
            return false;
        }
    }

    static final class DelegatingConnectionObserver
    implements ConnectionObserver {
        DelegatingConnectionObserver() {
        }

        public void onUncaughtException(Connection connection, Throwable error) {
            this.owner(connection.channel()).onUncaughtException(connection, error);
        }

        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            this.owner(connection.channel()).onStateChange(connection, newState);
        }

        ConnectionObserver owner(Channel channel) {
            ConnectionObserver obs;
            do {
                if ((obs = (ConnectionObserver)channel.attr(OWNER).get()) != null) {
                    return obs;
                }
                obs = new PendingConnectionObserver();
            } while (!channel.attr(OWNER).compareAndSet(null, (Object)obs));
            return obs;
        }
    }
}

