/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Map;
import reactor.netty.Metrics;
import reactor.netty.channel.MeterKey;
import reactor.netty.http.MicrometerHttpMetricsRecorder;
import reactor.netty.http.client.HttpClientMeters;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.netty.internal.util.MapUtils;
import reactor.util.annotation.Nullable;

final class MicrometerHttpClientMetricsRecorder
extends MicrometerHttpMetricsRecorder
implements HttpClientMetricsRecorder {
    static final MicrometerHttpClientMetricsRecorder INSTANCE = new MicrometerHttpClientMetricsRecorder();

    private MicrometerHttpClientMetricsRecorder() {
        super("reactor.netty.http.client", "http");
    }

    @Override
    public void recordDataReceivedTime(SocketAddress remoteAddress, String uri, String method, String status, Duration time) {
        String address = Metrics.formatSocketAddress((SocketAddress)remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, method, status);
        Timer dataReceivedTime = (Timer)MapUtils.computeIfAbsent((Map)this.dataReceivedTimeCache, (Object)meterKey, key -> (Timer)MicrometerHttpClientMetricsRecorder.filter((Meter)Timer.builder((String)(this.name() + ".data.received.time")).tags(new String[]{HttpClientMeters.DataReceivedTimeTags.REMOTE_ADDRESS.asString(), address, HttpClientMeters.DataReceivedTimeTags.URI.asString(), uri, HttpClientMeters.DataReceivedTimeTags.METHOD.asString(), method, HttpClientMeters.DataReceivedTimeTags.STATUS.asString(), status}).register(Metrics.REGISTRY)));
        if (dataReceivedTime != null) {
            dataReceivedTime.record(time);
        }
    }

    @Override
    public void recordDataSentTime(SocketAddress remoteAddress, String uri, String method, Duration time) {
        String address = Metrics.formatSocketAddress((SocketAddress)remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, method, null);
        Timer dataSentTime = (Timer)MapUtils.computeIfAbsent((Map)this.dataSentTimeCache, (Object)meterKey, key -> (Timer)MicrometerHttpClientMetricsRecorder.filter((Meter)Timer.builder((String)(this.name() + ".data.sent.time")).tags(new String[]{HttpClientMeters.DataSentTimeTags.REMOTE_ADDRESS.asString(), address, HttpClientMeters.DataSentTimeTags.URI.asString(), uri, HttpClientMeters.DataSentTimeTags.METHOD.asString(), method}).register(Metrics.REGISTRY)));
        if (dataSentTime != null) {
            dataSentTime.record(time);
        }
    }

    @Override
    public void recordResponseTime(SocketAddress remoteAddress, String uri, String method, String status, Duration time) {
        String address = Metrics.formatSocketAddress((SocketAddress)remoteAddress);
        Timer responseTime = this.getResponseTimeTimer(this.name() + ".response.time", address, uri, method, status);
        if (responseTime != null) {
            responseTime.record(time);
        }
    }

    @Nullable
    final Timer getResponseTimeTimer(String name, String address, String uri, String method, String status) {
        MeterKey meterKey = new MeterKey(uri, address, method, status);
        return (Timer)MapUtils.computeIfAbsent((Map)this.responseTimeCache, (Object)meterKey, key -> (Timer)MicrometerHttpClientMetricsRecorder.filter((Meter)Timer.builder((String)name).tags(new String[]{"remote.address", address, "uri", uri, "method", method, "status", status}).register(Metrics.REGISTRY)));
    }
}

