/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.handler.logging.LoggingHandler;
import io.netty.incubator.codec.http3.Http3;
import io.netty.incubator.codec.http3.Http3ClientConnectionHandler;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicChannelBootstrap;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.incubator.codec.quic.QuicStreamChannelBootstrap;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.Http2ConnectionProvider;
import reactor.netty.http.client.Http2Pool;
import reactor.netty.http.client.Http3ChannelInitializer;
import reactor.netty.http.client.Http3Codec;
import reactor.netty.http.client.Http3Pool;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.http.client.HttpDelegatingConnectionPoolMetrics;
import reactor.netty.http.client.MicrometerHttp2ConnectionProviderMeterRegistrar;
import reactor.netty.http.client.MicrometerPoolMetricsRecorder;
import reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import reactor.netty.internal.shaded.reactor.pool.PoolMetricsRecorder;
import reactor.netty.internal.shaded.reactor.pool.PooledRef;
import reactor.netty.internal.shaded.reactor.pool.PooledRefMetadata;
import reactor.netty.resources.ConnectionPoolMetrics;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.PooledConnectionProvider;
import reactor.netty.transport.TransportConfig;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

final class Http3ConnectionProvider
extends PooledConnectionProvider<Connection> {
    final ConnectionProvider parent;
    static final String CONNECTION_PROVIDER_NAME = "http3";
    static final String NAME_SEPARATOR = ".";
    static final Logger log = Loggers.getLogger(Http3ConnectionProvider.class);
    static final AttributeKey<@Nullable ConnectionObserver> OWNER = AttributeKey.valueOf((String)"http3ConnectionOwner");

    Http3ConnectionProvider(ConnectionProvider parent) {
        super(Http3ConnectionProvider.initConfiguration(parent));
        this.parent = parent;
        if (parent instanceof PooledConnectionProvider) {
            ((PooledConnectionProvider)parent).onDispose(this.disposeLater());
        }
    }

    static ConnectionProvider.Builder initConfiguration(ConnectionProvider parent) {
        String name = parent.name() == null ? CONNECTION_PROVIDER_NAME : "http3." + parent.name();
        ConnectionProvider.Builder builder = parent.mutate();
        if (builder != null) {
            return (ConnectionProvider.Builder)builder.name(name).pendingAcquireMaxCount(-1);
        }
        return (ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)name).maxConnections(parent.maxConnections())).pendingAcquireMaxCount(-1);
    }

    protected CoreSubscriber<PooledRef<Connection>> createDisposableAcquire(TransportConfig config, ConnectionObserver connectionObserver, long pendingAcquireTimeout, InstrumentedPool<Connection> pool, MonoSink<Connection> sink, Context currentContext) {
        return this.createDisposableAcquire(config, connectionObserver, pendingAcquireTimeout, pool, null, sink, currentContext);
    }

    protected CoreSubscriber<PooledRef<Connection>> createDisposableAcquire(TransportConfig config, ConnectionObserver connectionObserver, long pendingAcquireTimeout, InstrumentedPool<Connection> pool, SocketAddress remoteAddress, MonoSink<Connection> sink, Context currentContext) {
        ChannelMetricsRecorder metricsRecorder = config.metricsRecorder() != null ? (ChannelMetricsRecorder)config.metricsRecorder().get() : null;
        boolean acceptGzip = false;
        Function<String, String> uriTagValue = null;
        boolean validate = true;
        if (config instanceof HttpClientConfig) {
            acceptGzip = ((HttpClientConfig)config).acceptGzip;
            uriTagValue = ((HttpClientConfig)config).uriTagValue;
            validate = ((HttpClientConfig)config).decoder.validateHeaders();
        }
        return new DisposableAcquire(acceptGzip, config.attributes(), currentContext, config.loggingHandler(), metricsRecorder, pendingAcquireTimeout, pool, connectionObserver, config.channelOperationsProvider(), config.options(), remoteAddress, sink, uriTagValue, validate);
    }

    protected InstrumentedPool<Connection> createPool(TransportConfig config, PooledConnectionProvider.PoolFactory<Connection> poolFactory, SocketAddress remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        return new PooledConnectionAllocator((ConnectionProvider)this.parent, (TransportConfig)config, poolFactory, (SocketAddress)remoteAddress, resolverGroup).pool;
    }

    protected InstrumentedPool<Connection> createPool(String id, TransportConfig config, PooledConnectionProvider.PoolFactory<Connection> poolFactory, SocketAddress remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        return new PooledConnectionAllocator((String)id, (String)this.name(), (ConnectionProvider)this.parent, (TransportConfig)config, poolFactory, (SocketAddress)remoteAddress, resolverGroup).pool;
    }

    protected ConnectionPoolMetrics delegateConnectionPoolMetrics(InstrumentedPool.PoolMetrics metrics) {
        return new HttpDelegatingConnectionPoolMetrics((Http2Pool)metrics);
    }

    protected void registerDefaultMetrics(String id, SocketAddress remoteAddress, InstrumentedPool.PoolMetrics metrics) {
        MicrometerHttp2ConnectionProviderMeterRegistrar.INSTANCE.registerMetrics(this.name(), id, remoteAddress, metrics);
    }

    protected void deRegisterDefaultMetrics(String id, SocketAddress remoteAddress) {
        MicrometerHttp2ConnectionProviderMeterRegistrar.INSTANCE.deRegisterMetrics(this.name(), id, remoteAddress);
    }

    static void invalidate(@Nullable ConnectionObserver owner) {
        if (owner instanceof DisposableAcquire) {
            DisposableAcquire da = (DisposableAcquire)owner;
            da.pooledRef.invalidate().subscribe();
        }
    }

    static void registerClose(Channel channel, ConnectionObserver owner) {
        channel.closeFuture().addListener(f -> {
            if (owner instanceof DisposableAcquire) {
                DisposableAcquire da = (DisposableAcquire)owner;
                da.pooledRef.invalidate().subscribe(null, null, () -> {
                    if (log.isDebugEnabled()) {
                        Http2Pool.Http2PooledRef http2PooledRef = Http2ConnectionProvider.http2PooledRef(da.pooledRef);
                        Http2ConnectionProvider.logStreamsState(channel, http2PooledRef.slot, "Stream closed");
                    }
                });
            }
        });
    }

    static final class PooledConnectionAllocator {
        final ConnectionProvider parent;
        final HttpClientConfig config;
        final InstrumentedPool<Connection> pool;
        final SocketAddress remoteAddress;
        final @Nullable AddressResolverGroup<?> resolver;
        static final BiPredicate<Connection, PooledRefMetadata> DEFAULT_EVICTION_PREDICATE = (connection, metadata) -> false;
        static final Function<Connection, Publisher<Void>> DEFAULT_DESTROY_HANDLER = connection -> Mono.empty();

        PooledConnectionAllocator(ConnectionProvider parent, TransportConfig config, PooledConnectionProvider.PoolFactory<Connection> poolFactory, SocketAddress remoteAddress, @Nullable AddressResolverGroup<?> resolver) {
            this(null, null, parent, config, poolFactory, remoteAddress, resolver);
        }

        PooledConnectionAllocator(@Nullable String id, @Nullable String name, ConnectionProvider parent, TransportConfig config, PooledConnectionProvider.PoolFactory<Connection> poolFactory, SocketAddress remoteAddress, @Nullable AddressResolverGroup<?> resolver) {
            this.parent = parent;
            this.config = (HttpClientConfig)config;
            this.remoteAddress = remoteAddress;
            this.resolver = resolver;
            this.pool = id == null ? poolFactory.newPool(this.connectChannel(), null, DEFAULT_DESTROY_HANDLER, DEFAULT_EVICTION_PREDICATE, poolConfig -> new Http3Pool((PoolConfig<Connection>)poolConfig, poolFactory.allocationStrategy())) : poolFactory.newPool(this.connectChannel(), DEFAULT_DESTROY_HANDLER, DEFAULT_EVICTION_PREDICATE, (PoolMetricsRecorder)new MicrometerPoolMetricsRecorder(id, name, remoteAddress), poolConfig -> new Http3Pool((PoolConfig<Connection>)poolConfig, poolFactory.allocationStrategy()));
        }

        Publisher<Connection> connectChannel() {
            return this.parent.acquire((TransportConfig)this.config, (ConnectionObserver)new DelegatingConnectionObserver(), () -> this.remoteAddress, null).flatMap(conn -> Mono.create(sink -> {
                AddressResolver addrResolver;
                Channel channel = conn.channel();
                channel.pipeline().remove("reactor.right.reactiveBridge");
                Http3ChannelInitializer.HttpTrafficHandler initializer = (Http3ChannelInitializer.HttpTrafficHandler)channel.pipeline().remove(Http3ChannelInitializer.HttpTrafficHandler.class);
                try {
                    addrResolver = Objects.requireNonNull(this.resolver).getResolver((EventExecutor)channel.eventLoop());
                }
                catch (Throwable t) {
                    channel.close();
                    sink.error(t);
                    return;
                }
                if (!addrResolver.isSupported(this.remoteAddress) || addrResolver.isResolved(this.remoteAddress)) {
                    PooledConnectionAllocator.connect(channel, (TransportConfig)this.config, initializer.quicChannelInitializer, this.remoteAddress, (MonoSink<Connection>)sink);
                } else {
                    Future resolveFuture = addrResolver.resolve(this.remoteAddress);
                    if (resolveFuture.isDone()) {
                        Throwable cause = resolveFuture.cause();
                        if (cause != null) {
                            channel.close();
                            sink.error(cause);
                        } else {
                            PooledConnectionAllocator.connect(channel, (TransportConfig)this.config, initializer.quicChannelInitializer, (SocketAddress)resolveFuture.getNow(), (MonoSink<Connection>)sink);
                        }
                    } else {
                        resolveFuture.addListener(future -> {
                            Throwable cause = future.cause();
                            if (cause != null) {
                                channel.close();
                                sink.error(cause);
                            } else {
                                PooledConnectionAllocator.connect(channel, (TransportConfig)this.config, initializer.quicChannelInitializer, (SocketAddress)future.getNow(), (MonoSink<Connection>)sink);
                            }
                        });
                    }
                }
            }));
        }

        static void attributes(QuicChannelBootstrap bootstrap, Map<AttributeKey<?>, ?> attrs) {
            for (Map.Entry<AttributeKey<?>, ?> e : attrs.entrySet()) {
                bootstrap.attr(e.getKey(), e.getValue());
            }
        }

        static void channelOptions(QuicChannelBootstrap bootstrap, Map<ChannelOption<?>, ?> options) {
            for (Map.Entry<ChannelOption<?>, ?> e : options.entrySet()) {
                bootstrap.option(e.getKey(), e.getValue());
            }
        }

        static void connect(Channel channel, TransportConfig config, ChannelHandler handler, SocketAddress remoteAddress, MonoSink<Connection> sink) {
            QuicChannelBootstrap bootstrap = QuicChannel.newBootstrap((Channel)channel).handler(handler).remoteAddress(remoteAddress);
            PooledConnectionAllocator.attributes(bootstrap, config.attributes());
            PooledConnectionAllocator.channelOptions(bootstrap, config.options());
            bootstrap.option(ChannelOption.AUTO_READ, (Object)true);
            bootstrap.connect().addListener(f -> {
                if (!f.isSuccess()) {
                    sink.error(f.cause());
                } else {
                    sink.success((Object)Connection.from((Channel)((Channel)f.get())));
                }
            });
        }
    }

    static final class PendingConnectionObserver
    implements ConnectionObserver {
        final Queue<Pending> pendingQueue = (Queue)Queues.unbounded((int)4).get();

        PendingConnectionObserver() {
        }

        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            this.pendingQueue.add(new Pending(connection, null, newState));
        }

        public void onUncaughtException(Connection connection, Throwable error) {
            this.pendingQueue.add(new Pending(connection, error, null));
        }

        static class Pending {
            final Connection connection;
            final @Nullable Throwable error;
            final // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable ConnectionObserver.State state;

            Pending(Connection connection, @Nullable Throwable error, // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable ConnectionObserver.State state) {
                this.connection = connection;
                this.error = error;
                this.state = state;
            }
        }
    }

    static final class DisposableAcquire
    implements CoreSubscriber<PooledRef<Connection>>,
    ConnectionObserver,
    Disposable,
    GenericFutureListener<Future<QuicStreamChannel>> {
        final boolean acceptGzip;
        final Map<AttributeKey<?>, ?> attributes;
        final Disposable.Composite cancellations;
        final Context currentContext;
        final @Nullable LoggingHandler loggingHandler;
        final @Nullable ChannelMetricsRecorder metricsRecorder;
        final long pendingAcquireTimeout;
        final InstrumentedPool<Connection> pool;
        final ConnectionObserver obs;
        final ChannelOperations.OnSetup opsFactory;
        final Map<ChannelOption<?>, ?> options;
        final boolean retried;
        final MonoSink<Connection> sink;
        final @Nullable Function<String, String> uriTagValue;
        final boolean validate;
        PooledRef<Connection> pooledRef;
        @Nullable SocketAddress remoteAddress;
        Subscription subscription;

        DisposableAcquire(boolean acceptGzip, Map<AttributeKey<?>, ?> attributes, Context currentContext, @Nullable LoggingHandler loggingHandler, @Nullable ChannelMetricsRecorder metricsRecorder, long pendingAcquireTimeout, InstrumentedPool<Connection> pool, ConnectionObserver obs, ChannelOperations.OnSetup opsFactory, Map<ChannelOption<?>, ?> options, @Nullable SocketAddress remoteAddress, MonoSink<Connection> sink, @Nullable Function<String, String> uriTagValue, boolean validate) {
            this.acceptGzip = acceptGzip;
            this.attributes = attributes;
            this.cancellations = Disposables.composite();
            this.currentContext = currentContext;
            this.loggingHandler = loggingHandler;
            this.metricsRecorder = metricsRecorder;
            this.pendingAcquireTimeout = pendingAcquireTimeout;
            this.pool = pool;
            this.obs = obs;
            this.opsFactory = opsFactory;
            this.options = options;
            this.remoteAddress = remoteAddress;
            this.retried = false;
            this.sink = sink;
            this.uriTagValue = uriTagValue;
            this.validate = validate;
        }

        DisposableAcquire(DisposableAcquire parent) {
            this.acceptGzip = parent.acceptGzip;
            this.attributes = parent.attributes;
            this.cancellations = parent.cancellations;
            this.currentContext = parent.currentContext;
            this.loggingHandler = parent.loggingHandler;
            this.metricsRecorder = parent.metricsRecorder;
            this.pendingAcquireTimeout = parent.pendingAcquireTimeout;
            this.pool = parent.pool;
            this.obs = parent.obs;
            this.opsFactory = parent.opsFactory;
            this.options = parent.options;
            this.remoteAddress = parent.remoteAddress;
            this.retried = true;
            this.sink = parent.sink;
            this.uriTagValue = parent.uriTagValue;
            this.validate = parent.validate;
        }

        public Context currentContext() {
            return this.currentContext;
        }

        public void dispose() {
            this.subscription.cancel();
        }

        public void onComplete() {
        }

        public void onError(Throwable t) {
            this.sink.error(t);
        }

        public void onNext(PooledRef<Connection> pooledRef) {
            ConnectionObserver current;
            this.pooledRef = pooledRef;
            Channel channel = ((Connection)pooledRef.poolable()).channel();
            if (this.remoteAddress == null) {
                this.remoteAddress = channel.remoteAddress();
            }
            if ((current = (ConnectionObserver)channel.attr(OWNER).getAndSet((Object)this)) instanceof PendingConnectionObserver) {
                PendingConnectionObserver.Pending p;
                PendingConnectionObserver pending = (PendingConnectionObserver)current;
                while ((p = pending.pendingQueue.poll()) != null) {
                    if (p.error != null) {
                        this.onUncaughtException(p.connection, p.error);
                        continue;
                    }
                    if (p.state == null) continue;
                    this.onStateChange(p.connection, p.state);
                }
            }
            if (ReactorNetty.getChannelContext((Channel)channel) != null) {
                ReactorNetty.setChannelContext((Channel)channel, null);
            }
            QuicStreamChannelBootstrap bootstrap = Http3.newRequestStreamBootstrap((QuicChannel)((QuicChannel)channel), (ChannelHandler)new Http3Codec(this.obs.then((ConnectionObserver)new HttpClientConfig.StreamConnectionObserver(this.currentContext())), this.opsFactory, this.acceptGzip, this.loggingHandler, this.metricsRecorder, this.remoteAddress, this.uriTagValue, this.validate));
            DisposableAcquire.attributes(bootstrap, this.attributes);
            DisposableAcquire.channelOptions(bootstrap, this.options);
            bootstrap.create().addListener((GenericFutureListener)this);
        }

        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            this.obs.onStateChange(connection, newState);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.subscription, (Subscription)s)) {
                this.subscription = s;
                this.cancellations.add((Disposable)this);
                if (!this.retried) {
                    this.sink.onCancel((Disposable)this.cancellations);
                }
                s.request(Long.MAX_VALUE);
            }
        }

        public void onUncaughtException(Connection connection, Throwable error) {
            this.obs.onUncaughtException(connection, error);
        }

        public void operationComplete(Future<QuicStreamChannel> future) {
            if (future.isSuccess()) {
                Channel channel = ((Connection)this.pooledRef.poolable()).channel();
                Http2Pool.Http2PooledRef http2PooledRef = DisposableAcquire.http2PooledRef(this.pooledRef);
                ChannelHandlerContext http3ClientConnectionHandlerCtx = ((Http3Pool.Slot)http2PooledRef.slot).http3ClientConnectionHandlerCtx();
                QuicStreamChannel ch = (QuicStreamChannel)future.getNow();
                if (!channel.isActive() || http3ClientConnectionHandlerCtx == null || ((Http3ClientConnectionHandler)http3ClientConnectionHandlerCtx.handler()).isGoAwayReceived()) {
                    Http3ConnectionProvider.invalidate(this);
                    if (!this.retried) {
                        if (log.isDebugEnabled()) {
                            log.debug(ReactorNetty.format((Channel)ch, (String)"Immediately aborted pooled channel, max active streams is reached, re-acquiring a new channel"));
                        }
                        this.pool.acquire(Duration.ofMillis(this.pendingAcquireTimeout)).contextWrite(ctx -> ctx.put((Object)"callereventloop", (Object)channel.eventLoop())).subscribe((CoreSubscriber)new DisposableAcquire(this));
                    } else {
                        this.sink.error((Throwable)new IOException("Error while acquiring from " + this.pool + ". Max active streams is reached."));
                    }
                } else {
                    ChannelOperations ops;
                    Http3ConnectionProvider.registerClose((Channel)ch, this);
                    if (!this.currentContext().isEmpty()) {
                        ReactorNetty.setChannelContext((Channel)ch, (ContextView)this.currentContext());
                    }
                    if ((ops = ChannelOperations.get((Channel)ch)) != null) {
                        this.sink.success((Object)ops);
                    }
                }
            } else {
                Http3ConnectionProvider.invalidate(this);
                this.sink.error(future.cause());
            }
        }

        static void attributes(QuicStreamChannelBootstrap bootstrap, Map<AttributeKey<?>, ?> attrs) {
            for (Map.Entry<AttributeKey<?>, ?> e : attrs.entrySet()) {
                bootstrap.attr(e.getKey(), e.getValue());
            }
        }

        static void channelOptions(QuicStreamChannelBootstrap bootstrap, Map<ChannelOption<?>, ?> options) {
            for (Map.Entry<ChannelOption<?>, ?> e : options.entrySet()) {
                bootstrap.option(e.getKey(), e.getValue());
            }
        }

        static Http2Pool.Http2PooledRef http2PooledRef(PooledRef<Connection> pooledRef) {
            return pooledRef instanceof Http2Pool.Http2PooledRef ? (Http2Pool.Http2PooledRef)pooledRef : (Http2Pool.Http2PooledRef)pooledRef.metadata();
        }
    }

    static final class DelegatingConnectionObserver
    implements ConnectionObserver {
        DelegatingConnectionObserver() {
        }

        public void onUncaughtException(Connection connection, Throwable error) {
            this.owner(connection.channel()).onUncaughtException(connection, error);
        }

        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            this.owner(connection.channel()).onStateChange(connection, newState);
        }

        ConnectionObserver owner(Channel channel) {
            ConnectionObserver obs;
            do {
                if ((obs = (ConnectionObserver)channel.attr(OWNER).get()) != null) {
                    return obs;
                }
                obs = new PendingConnectionObserver();
            } while (!channel.attr(OWNER).compareAndSet(null, (Object)obs));
            return obs;
        }
    }
}

