/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import org.jspecify.annotations.Nullable;

final class NonSslRedirectHandler
extends ChannelInboundHandlerAdapter {
    private static final String HTTP_PROTOCOL = "http://";
    private static final String HTTPS_PROTOCOL = "https://";

    NonSslRedirectHandler() {
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            ctx.pipeline().remove((ChannelHandler)this);
            HttpRequest request = (HttpRequest)msg;
            String url = this.getRequestedUrlInHttps(request);
            if (url == null) {
                ctx.close();
            } else {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.PERMANENT_REDIRECT);
                response.headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)url);
                ctx.channel().writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private @Nullable String getRequestedUrlInHttps(HttpRequest request) {
        String uri = request.uri();
        boolean isAbsoluteUri = uri.startsWith(HTTP_PROTOCOL);
        if (isAbsoluteUri) {
            return HTTPS_PROTOCOL + uri.substring(HTTP_PROTOCOL.length());
        }
        String host = request.headers().get((CharSequence)HttpHeaderNames.HOST);
        if (host == null) {
            return null;
        }
        return HTTPS_PROTOCOL + host + uri;
    }
}

