/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import io.netty.handler.codec.http2.Http2HeadersFrame;
import java.net.SocketAddress;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import reactor.netty.http.server.logging.AbstractAccessLogArgProvider;

final class AccessLogArgProviderH2
extends AbstractAccessLogArgProvider<AccessLogArgProviderH2> {
    static final String H2_PROTOCOL_NAME = "HTTP/2.0";
    @Nullable Http2HeadersFrame requestHeaders;
    @Nullable Http2HeadersFrame responseHeaders;

    AccessLogArgProviderH2(@Nullable SocketAddress remoteAddress) {
        super(remoteAddress);
    }

    AccessLogArgProviderH2 requestHeaders(Http2HeadersFrame requestHeaders) {
        this.requestHeaders = Objects.requireNonNull(requestHeaders, "requestHeaders");
        this.onRequest();
        return this.get();
    }

    AccessLogArgProviderH2 responseHeaders(Http2HeadersFrame responseHeaders) {
        this.responseHeaders = Objects.requireNonNull(responseHeaders, "responseHeaders");
        return this.get();
    }

    @Override
    public @Nullable CharSequence status() {
        return this.responseHeaders == null ? null : this.responseHeaders.headers().status();
    }

    @Override
    public @Nullable CharSequence requestHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        return this.requestHeaders == null ? null : (CharSequence)this.requestHeaders.headers().get((Object)name);
    }

    @Override
    public @Nullable CharSequence responseHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        return this.responseHeaders == null ? null : (CharSequence)this.responseHeaders.headers().get((Object)name);
    }

    @Override
    void onRequest() {
        super.onRequest();
        if (this.requestHeaders != null) {
            this.method = this.requestHeaders.headers().method();
            this.uri = this.requestHeaders.headers().path();
            this.protocol = H2_PROTOCOL_NAME;
        }
    }

    @Override
    void clear() {
        super.clear();
        this.requestHeaders = null;
        this.responseHeaders = null;
    }

    @Override
    public AccessLogArgProviderH2 get() {
        return this;
    }
}

