/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.logging.LoggingHandler;
import io.netty.incubator.codec.http3.Http3ClientConnectionHandler;
import io.netty.incubator.codec.http3.Http3FrameToHttpObjectCodec;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import java.net.SocketAddress;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.AbstractHttpClientMetricsHandler;
import reactor.netty.http.client.ContextAwareHttpClientMetricsHandler;
import reactor.netty.http.client.ContextAwareHttpClientMetricsRecorder;
import reactor.netty.http.client.Http2ConnectionProvider;
import reactor.netty.http.client.Http2Pool;
import reactor.netty.http.client.Http3ConnectionProvider;
import reactor.netty.http.client.Http3StreamBridgeClientHandler;
import reactor.netty.http.client.HttpClientMetricsHandler;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.netty.http.client.HttpClientOperations;
import reactor.netty.http.client.MicrometerHttpClientMetricsHandler;
import reactor.netty.http.client.MicrometerHttpClientMetricsRecorder;
import reactor.util.Logger;
import reactor.util.Loggers;

final class Http3Codec
extends ChannelInitializer<QuicStreamChannel> {
    static final Logger log = Loggers.getLogger(Http3Codec.class);
    final ConnectionObserver obs;
    final ChannelOperations.OnSetup opsFactory;
    final boolean acceptGzip;
    final @Nullable LoggingHandler loggingHandler;
    final @Nullable ChannelMetricsRecorder metricsRecorder;
    final SocketAddress remoteAddress;
    final @Nullable Function<String, String> uriTagValue;
    final boolean validate;
    static final Http3StreamBridgeClientHandler HTTP_3_STREAM_BRIDGE_CLIENT_HANDLER = new Http3StreamBridgeClientHandler();

    Http3Codec(ConnectionObserver obs, ChannelOperations.OnSetup opsFactory, boolean acceptGzip, @Nullable LoggingHandler loggingHandler, @Nullable ChannelMetricsRecorder metricsRecorder, SocketAddress remoteAddress, @Nullable Function<String, String> uriTagValue, boolean validate) {
        this.obs = obs;
        this.opsFactory = opsFactory;
        this.acceptGzip = acceptGzip;
        this.loggingHandler = loggingHandler;
        this.metricsRecorder = metricsRecorder;
        this.remoteAddress = remoteAddress;
        this.uriTagValue = uriTagValue;
        this.validate = validate;
    }

    protected void initChannel(QuicStreamChannel ch) {
        if (HttpClientOperations.log.isDebugEnabled()) {
            HttpClientOperations.log.debug(ReactorNetty.format((Channel)ch, (String)"New HTTP/3 stream"));
        }
        ChannelPipeline pipeline = ch.pipeline();
        if (this.loggingHandler != null) {
            pipeline.addLast("reactor.left.loggingHandler", (ChannelHandler)this.loggingHandler);
        }
        pipeline.addLast("reactor.left.h3ToHttp11Codec", (ChannelHandler)new Http3FrameToHttpObjectCodec(false, this.validate)).addLast("reactor.left.httpTrafficHandler", (ChannelHandler)HTTP_3_STREAM_BRIDGE_CLIENT_HANDLER);
        if (this.acceptGzip) {
            pipeline.addLast("reactor.left.httpDecompressor", (ChannelHandler)new HttpContentDecompressor());
        }
        ChannelOperations.addReactiveBridge((Channel)ch, (ChannelOperations.OnSetup)this.opsFactory, (ConnectionObserver)this.obs);
        if (this.metricsRecorder != null && this.metricsRecorder instanceof HttpClientMetricsRecorder) {
            AbstractHttpClientMetricsHandler handler = this.metricsRecorder instanceof MicrometerHttpClientMetricsRecorder ? new MicrometerHttpClientMetricsHandler((MicrometerHttpClientMetricsRecorder)this.metricsRecorder, this.remoteAddress, null, this.uriTagValue) : (this.metricsRecorder instanceof ContextAwareHttpClientMetricsRecorder ? new ContextAwareHttpClientMetricsHandler((ContextAwareHttpClientMetricsRecorder)this.metricsRecorder, this.remoteAddress, null, this.uriTagValue) : new HttpClientMetricsHandler((HttpClientMetricsRecorder)this.metricsRecorder, this.remoteAddress, null, this.uriTagValue));
            pipeline.addBefore("reactor.right.reactiveBridge", "reactor.left.httpMetricsHandler", (ChannelHandler)handler);
        }
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format((Channel)ch, (String)"Initialized HTTP/3 stream pipeline {}"), new Object[]{ch.pipeline()});
            ConnectionObserver owner = (ConnectionObserver)ch.parent().attr(Http3ConnectionProvider.OWNER).get();
            if (owner instanceof Http3ConnectionProvider.DisposableAcquire) {
                Http3ConnectionProvider.DisposableAcquire da = (Http3ConnectionProvider.DisposableAcquire)owner;
                Http2Pool.Http2PooledRef http2PooledRef = Http2ConnectionProvider.http2PooledRef(da.pooledRef);
                Http2ConnectionProvider.logStreamsState((Channel)ch, http2PooledRef.slot, "Stream opened");
            }
        }
    }

    static ChannelHandler newHttp3ClientConnectionHandler() {
        return new Http3ClientConnectionHandler();
    }
}

