/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.quic;

import io.netty.handler.codec.quic.QuicConnectionIdGenerator;
import io.netty.handler.codec.quic.QuicTokenHandler;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.quic.QuicConnection;
import reactor.netty.quic.QuicServerBind;
import reactor.netty.quic.QuicServerConfig;
import reactor.netty.quic.QuicTransport;
import reactor.netty.transport.AddressUtils;
import reactor.util.Logger;
import reactor.util.Loggers;

public abstract class QuicServer
extends QuicTransport<QuicServer, QuicServerConfig> {
    static final Logger log = Loggers.getLogger(QuicServer.class);

    public static QuicServer create() {
        return QuicServerBind.INSTANCE;
    }

    public abstract Mono<? extends Connection> bind();

    public final Connection bindNow() {
        return this.bindNow(Duration.ofSeconds(45L));
    }

    public final Connection bindNow(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        try {
            return Objects.requireNonNull((Connection)this.bind().block(timeout), "aborted");
        }
        catch (IllegalStateException e) {
            String message = e.getMessage();
            if (message != null && message.contains("blocking read")) {
                throw new IllegalStateException("QuicServer couldn't be started within " + timeout.toMillis() + "ms");
            }
            throw e;
        }
    }

    public final QuicServer connectionIdAddressGenerator(QuicConnectionIdGenerator connectionIdAddressGenerator) {
        Objects.requireNonNull(connectionIdAddressGenerator, "connectionIdAddressGenerator");
        QuicServer dup = (QuicServer)this.duplicate();
        ((QuicServerConfig)dup.configuration()).connectionIdAddressGenerator = connectionIdAddressGenerator;
        return dup;
    }

    public final QuicServer doOnConnection(Consumer<? super QuicConnection> doOnConnection) {
        Objects.requireNonNull(doOnConnection, "doOnConnected");
        QuicServer dup = (QuicServer)this.duplicate();
        Consumer<? super QuicConnection> current = ((QuicServerConfig)this.configuration()).doOnConnection;
        ((QuicServerConfig)dup.configuration()).doOnConnection = current == null ? doOnConnection : current.andThen(doOnConnection);
        return dup;
    }

    public final QuicServer host(String host) {
        return (QuicServer)this.bindAddress(() -> AddressUtils.updateHost((Supplier)((QuicServerConfig)this.configuration()).bindAddress(), (String)host));
    }

    public final QuicServer port(int port) {
        return (QuicServer)this.bindAddress(() -> AddressUtils.updatePort((Supplier)((QuicServerConfig)this.configuration()).bindAddress(), (int)port));
    }

    public final QuicServer tokenHandler(QuicTokenHandler tokenHandler) {
        Objects.requireNonNull(tokenHandler, "tokenHandler");
        QuicServer dup = (QuicServer)this.duplicate();
        ((QuicServerConfig)dup.configuration()).tokenHandler = tokenHandler;
        return dup;
    }
}

