/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.quic;

import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.netty.quic.QuicClientConfig;
import reactor.netty.quic.QuicClientConnect;
import reactor.netty.quic.QuicConnection;
import reactor.netty.quic.QuicTransport;
import reactor.netty.transport.AddressUtils;

public abstract class QuicClient
extends QuicTransport<QuicClient, QuicClientConfig> {
    public static QuicClient create() {
        return QuicClientConnect.INSTANCE;
    }

    public abstract Mono<? extends QuicConnection> connect();

    public final QuicConnection connectNow() {
        return this.connectNow(Duration.ofSeconds(45L));
    }

    public final QuicConnection connectNow(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        try {
            return Objects.requireNonNull((QuicConnection)this.connect().block(timeout), "aborted");
        }
        catch (IllegalStateException e) {
            String message = e.getMessage();
            if (message != null && message.contains("blocking read")) {
                throw new IllegalStateException("QuicClient couldn't be started within " + timeout.toMillis() + "ms");
            }
            throw e;
        }
    }

    public final QuicClient doOnConnect(Consumer<? super QuicClientConfig> doOnConnect) {
        Objects.requireNonNull(doOnConnect, "doOnConnect");
        QuicClient dup = (QuicClient)this.duplicate();
        Consumer<? super QuicClientConfig> current = ((QuicClientConfig)this.configuration()).doOnConnect;
        ((QuicClientConfig)dup.configuration()).doOnConnect = current == null ? doOnConnect : current.andThen(doOnConnect);
        return dup;
    }

    public final QuicClient doOnConnected(Consumer<? super QuicConnection> doOnConnected) {
        Objects.requireNonNull(doOnConnected, "doOnConnected");
        QuicClient dup = (QuicClient)this.duplicate();
        Consumer<? super QuicConnection> current = ((QuicClientConfig)this.configuration()).doOnConnected;
        ((QuicClientConfig)dup.configuration()).doOnConnected = current == null ? doOnConnected : current.andThen(doOnConnected);
        return dup;
    }

    public final QuicClient doOnDisconnected(Consumer<? super QuicConnection> doOnDisconnected) {
        Objects.requireNonNull(doOnDisconnected, "doOnDisconnected");
        QuicClient dup = (QuicClient)this.duplicate();
        Consumer<? super QuicConnection> current = ((QuicClientConfig)this.configuration()).doOnDisconnected;
        ((QuicClientConfig)dup.configuration()).doOnDisconnected = current == null ? doOnDisconnected : current.andThen(doOnDisconnected);
        return dup;
    }

    public final QuicClient host(String host) {
        Objects.requireNonNull(host, "host");
        return this.remoteAddress(() -> AddressUtils.updateHost(((QuicClientConfig)this.configuration()).remoteAddress(), (String)host));
    }

    public final QuicClient port(int port) {
        return this.remoteAddress(() -> AddressUtils.updatePort(((QuicClientConfig)this.configuration()).remoteAddress(), (int)port));
    }

    public final QuicClient remoteAddress(Supplier<? extends SocketAddress> remoteAddressSupplier) {
        Objects.requireNonNull(remoteAddressSupplier, "remoteAddressSupplier");
        QuicClient dup = (QuicClient)this.duplicate();
        ((QuicClientConfig)dup.configuration()).remoteAddress = remoteAddressSupplier;
        return dup;
    }
}

