/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.BindException;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Supplier;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.netty.ChannelBindException;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.resources.ConnectionProvider;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;

final class NewConnectionProvider
implements ConnectionProvider {
    static final Logger log = Loggers.getLogger(NewConnectionProvider.class);
    static final NewConnectionProvider INSTANCE = new NewConnectionProvider();

    NewConnectionProvider() {
    }

    @Override
    public Mono<? extends Connection> acquire(Bootstrap b) {
        return Mono.create(sink -> {
            ChannelFuture f;
            Bootstrap bootstrap = b.clone();
            ChannelOperations.OnSetup factory = BootstrapHandlers.channelOperationFactory(bootstrap);
            ConnectionObserver obs = BootstrapHandlers.connectionObserver(bootstrap);
            BootstrapHandlers.finalizeHandler(bootstrap, factory, (ConnectionObserver)new NewConnectionObserver((MonoSink<Connection>)sink, obs));
            if (bootstrap.config().remoteAddress() != null) {
                NewConnectionProvider.convertLazyRemoteAddress(bootstrap);
                f = bootstrap.connect();
            } else {
                f = bootstrap.bind();
            }
            DisposableConnect disposableConnect = new DisposableConnect((MonoSink<Connection>)sink, f, bootstrap);
            f.addListener((GenericFutureListener)disposableConnect);
            sink.onCancel((Disposable)disposableConnect);
        });
    }

    public boolean isDisposed() {
        return false;
    }

    static void convertLazyRemoteAddress(Bootstrap b) {
        SocketAddress remote = b.config().remoteAddress();
        Objects.requireNonNull(remote, "Remote Address not configured");
        if (remote instanceof Supplier) {
            Supplier lazyRemote = (Supplier)((Object)remote);
            b.remoteAddress(Objects.requireNonNull((SocketAddress)lazyRemote.get(), "address supplier returned null"));
        }
    }

    static final class NewConnectionObserver
    implements ConnectionObserver {
        final MonoSink<Connection> sink;
        final ConnectionObserver obs;

        NewConnectionObserver(MonoSink<Connection> sink, ConnectionObserver obs) {
            this.sink = sink;
            this.obs = obs;
        }

        @Override
        public Context currentContext() {
            return this.sink.currentContext();
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(connection.channel(), "onStateChange({}, {})"), new Object[]{newState, connection});
            }
            if (newState == ConnectionObserver.State.CONFIGURED) {
                this.sink.success((Object)connection);
            } else if (newState == ConnectionObserver.State.DISCONNECTING && connection.channel().isActive()) {
                connection.channel().close();
            }
            this.obs.onStateChange(connection, newState);
        }

        @Override
        public void onUncaughtException(Connection c, Throwable error) {
            log.error(ReactorNetty.format(c.channel(), "onUncaughtException(" + c + ")"), error);
            this.sink.error(error);
            this.obs.onUncaughtException(c, error);
        }
    }

    static final class DisposableConnect
    implements Disposable,
    ChannelFutureListener {
        final MonoSink<Connection> sink;
        final ChannelFuture f;
        final Bootstrap bootstrap;

        DisposableConnect(MonoSink<Connection> sink, ChannelFuture f, Bootstrap bootstrap) {
            this.sink = sink;
            this.f = f;
            this.bootstrap = bootstrap;
        }

        public final void dispose() {
            if (this.isDisposed()) {
                return;
            }
            this.f.removeListener((GenericFutureListener)this);
            if (!this.f.isDone()) {
                this.f.cancel(true);
            }
        }

        public boolean isDisposed() {
            return this.f.isCancelled() || this.f.isDone();
        }

        public final void operationComplete(ChannelFuture f) {
            if (!f.isSuccess()) {
                if (f.isCancelled()) {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format(f.channel(), "Channel cancelled"));
                    }
                    return;
                }
                if (f.cause() != null) {
                    if (f.cause() instanceof BindException) {
                        this.sink.error((Throwable)ChannelBindException.fail(this.bootstrap, f.cause()));
                    } else {
                        this.sink.error(f.cause());
                    }
                } else {
                    this.sink.error((Throwable)new IOException("error while connecting to " + f.channel()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(f.channel(), "Connected new channel"));
            }
        }
    }
}

