/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.stream.ChunkedNioFile;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.NettyPipeline;
import reactor.netty.ReactorNetty;

public interface NettyOutbound
extends Publisher<Void> {
    public ByteBufAllocator alloc();

    default public Mono<Void> neverComplete() {
        return this.then((Publisher<Void>)Mono.never()).then();
    }

    @Deprecated
    public NettyOutbound options(Consumer<? super NettyPipeline.SendOptions> var1);

    public NettyOutbound send(Publisher<? extends ByteBuf> var1);

    default public NettyOutbound sendByteArray(Publisher<? extends byte[]> dataStream) {
        return this.send(ReactorNetty.publisherOrScalarMap(dataStream, Unpooled::wrappedBuffer));
    }

    default public NettyOutbound sendFile(Path file) {
        try {
            return this.sendFile(file, 0L, Files.size(file));
        }
        catch (IOException e) {
            return this.then((Publisher<Void>)Mono.error((Throwable)e));
        }
    }

    default public NettyOutbound sendFile(Path file, long position, long count) {
        Objects.requireNonNull(file, "filepath");
        return this.sendUsing(() -> FileChannel.open(file, StandardOpenOption.READ), (c, fc) -> {
            if (ReactorNetty.mustChunkFileTransfer(c, file)) {
                ReactorNetty.addChunkedWriter(c);
                try {
                    return new ChunkedNioFile(fc, position, count, 1024);
                }
                catch (Exception ioe) {
                    throw Exceptions.propagate((Throwable)ioe);
                }
            }
            return new DefaultFileRegion(fc, position, count);
        }, ReactorNetty.fileCloser);
    }

    default public NettyOutbound sendFileChunked(Path file, long position, long count) {
        Objects.requireNonNull(file, "filepath");
        return this.sendUsing(() -> FileChannel.open(file, StandardOpenOption.READ), (c, fc) -> {
            ReactorNetty.addChunkedWriter(c);
            try {
                return new ChunkedNioFile(fc, position, count, 1024);
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }, ReactorNetty.fileCloser);
    }

    default public NettyOutbound sendGroups(Publisher<? extends Publisher<? extends ByteBuf>> dataStreams) {
        return this.then((Publisher<Void>)Flux.from(dataStreams).concatMapDelayError(this::send, false, 32).then());
    }

    public NettyOutbound sendObject(Publisher<?> var1);

    public NettyOutbound sendObject(Object var1);

    default public NettyOutbound sendString(Publisher<? extends String> dataStream) {
        return this.sendString(dataStream, Charset.defaultCharset());
    }

    default public NettyOutbound sendString(Publisher<? extends String> dataStream, Charset charset) {
        return this.send(ReactorNetty.publisherOrScalarMap(dataStream, s -> {
            ByteBuf buffer = this.alloc().buffer();
            buffer.writeCharSequence((CharSequence)s, charset);
            return buffer;
        }));
    }

    public <S> NettyOutbound sendUsing(Callable<? extends S> var1, BiFunction<? super Connection, ? super S, ?> var2, Consumer<? super S> var3);

    default public void subscribe(Subscriber<? super Void> s) {
        this.then().subscribe(s);
    }

    default public Mono<Void> then() {
        return Mono.empty();
    }

    default public NettyOutbound then(Publisher<Void> other) {
        return new ReactorNetty.OutboundThen(this, other);
    }

    default public NettyOutbound then(Publisher<Void> other, Runnable onCleanup) {
        return new ReactorNetty.OutboundThen(this, other, onCleanup);
    }

    public NettyOutbound withConnection(Consumer<? super Connection> var1);
}

