/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.FutureMono;
import reactor.netty.NettyInbound;
import reactor.netty.NettyOutbound;
import reactor.netty.NettyPipeline;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.AbortedException;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.HttpInfos;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public abstract class HttpOperations<INBOUND extends NettyInbound, OUTBOUND extends NettyOutbound>
extends ChannelOperations<INBOUND, OUTBOUND>
implements HttpInfos {
    volatile int statusAndHeadersSent = 0;
    static final int READY = 0;
    static final int HEADERS_SENT = 1;
    static final int BODY_SENT = 2;
    static final AtomicIntegerFieldUpdater<HttpOperations> HTTP_STATE = AtomicIntegerFieldUpdater.newUpdater(HttpOperations.class, "statusAndHeadersSent");
    static final ChannelInboundHandler HTTP_EXTRACTOR = NettyPipeline.inboundHandler((ctx, msg) -> {
        if (msg instanceof ByteBufHolder) {
            if (msg instanceof FullHttpMessage) {
                ctx.fireChannelRead(msg);
            } else {
                ByteBuf bb = ((ByteBufHolder)msg).content();
                ctx.fireChannelRead((Object)bb);
                if (msg instanceof LastHttpContent) {
                    ctx.fireChannelRead((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                }
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    });
    static final Logger log = Loggers.getLogger(HttpOperations.class);

    protected HttpOperations(HttpOperations<INBOUND, OUTBOUND> replaced) {
        super(replaced);
        this.statusAndHeadersSent = replaced.statusAndHeadersSent;
    }

    protected HttpOperations(Connection connection, ConnectionObserver listener) {
        super(connection, listener);
    }

    public final boolean hasSentHeaders() {
        return this.statusAndHeadersSent != 0;
    }

    @Override
    public boolean isWebsocket() {
        return false;
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> source) {
        if (source instanceof Mono) {
            return new PostHeadersNettyOutbound((Mono<Void>)((Mono)source).flatMap(msg -> {
                if (this.markSentHeaderAndBody()) {
                    try {
                        this.preSendHeadersAndStatus();
                    }
                    catch (RuntimeException e) {
                        ReferenceCountUtil.release((Object)msg);
                        throw e;
                    }
                    if (HttpUtil.getContentLength((HttpMessage)this.outboundHttpMessage(), (int)-1) == 0) {
                        log.debug(ReactorNetty.format(this.channel(), "Dropped HTTP content, since response has Content-Length: 0 {}"), new Object[]{ReactorNetty.toPrettyHexDump(msg)});
                        msg.release();
                        return FutureMono.from(this.channel().writeAndFlush((Object)this.newFullBodyMessage(Unpooled.EMPTY_BUFFER)));
                    }
                    return FutureMono.from(this.channel().writeAndFlush((Object)this.newFullBodyMessage((ByteBuf)msg)));
                }
                return FutureMono.from(this.channel().writeAndFlush(msg));
            }).doOnDiscard(ByteBuf.class, ReferenceCounted::release), this, null);
        }
        return super.send(source);
    }

    @Override
    public NettyOutbound sendObject(Object message) {
        if (!(message instanceof ByteBuf)) {
            return super.sendObject(message);
        }
        ByteBuf b = (ByteBuf)message;
        return new PostHeadersNettyOutbound(FutureMono.deferFuture(() -> {
            if (this.markSentHeaderAndBody()) {
                try {
                    this.preSendHeadersAndStatus();
                }
                catch (RuntimeException e) {
                    b.release();
                    throw e;
                }
                if (HttpUtil.getContentLength((HttpMessage)this.outboundHttpMessage(), (int)-1) == 0) {
                    log.debug(ReactorNetty.format(this.channel(), "Dropped HTTP content, since response has Content-Length: 0 {}"), new Object[]{ReactorNetty.toPrettyHexDump(b)});
                    b.release();
                    return this.channel().writeAndFlush((Object)this.newFullBodyMessage(Unpooled.EMPTY_BUFFER));
                }
                return this.channel().writeAndFlush((Object)this.newFullBodyMessage(b));
            }
            return this.channel().writeAndFlush((Object)b);
        }), this, b);
    }

    @Override
    public Mono<Void> then() {
        if (!this.channel().isActive()) {
            return Mono.error((Throwable)new AbortedException("Connection has been closed BEFORE response"));
        }
        if (this.hasSentHeaders()) {
            return Mono.empty();
        }
        return FutureMono.deferFuture(() -> {
            if (this.markSentHeaders()) {
                HttpMessage msg;
                if (HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage())) {
                    this.outboundHttpMessage().headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                    if (HttpUtil.getContentLength((HttpMessage)this.outboundHttpMessage(), (int)0) == 0) {
                        this.markSentBody();
                        msg = this.newFullBodyMessage(Unpooled.EMPTY_BUFFER);
                    } else {
                        msg = this.outboundHttpMessage();
                    }
                } else {
                    msg = this.outboundHttpMessage();
                }
                try {
                    this.preSendHeadersAndStatus();
                }
                catch (RuntimeException e) {
                    ReferenceCountUtil.release((Object)msg);
                    throw e;
                }
                return this.channel().writeAndFlush((Object)msg);
            }
            return this.channel().newSucceededFuture();
        });
    }

    protected abstract void preSendHeadersAndStatus();

    protected abstract HttpMessage newFullBodyMessage(ByteBuf var1);

    @Override
    public final NettyOutbound sendFile(Path file, long position, long count) {
        Objects.requireNonNull(file);
        if (this.hasSentHeaders()) {
            return super.sendFile(file, position, count);
        }
        if (!HttpUtil.isTransferEncodingChunked((HttpMessage)this.outboundHttpMessage()) && !HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage()) && count < Integer.MAX_VALUE) {
            this.outboundHttpMessage().headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (int)count);
        } else if (!HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage())) {
            this.outboundHttpMessage().headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH).remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.outboundHttpMessage(), (boolean)true);
        }
        return super.sendFile(file, position, count);
    }

    @Override
    public String toString() {
        if (this.isWebsocket()) {
            return "ws{uri=" + this.uri() + ", connection=" + this.connection() + "}";
        }
        return this.method().name() + "{uri=" + this.uri() + ", connection=" + this.connection() + "}";
    }

    @Override
    public HttpOperations<INBOUND, OUTBOUND> addHandler(String name, ChannelHandler handler) {
        super.addHandler(name, handler);
        if (this.channel().pipeline().context(handler) == null) {
            return this;
        }
        HttpOperations.autoAddHttpExtractor(this, name, handler);
        return this;
    }

    static void autoAddHttpExtractor(Connection c, String name, ChannelHandler handler) {
        if (handler instanceof ByteToMessageDecoder || handler instanceof ByteToMessageCodec || handler instanceof CombinedChannelDuplexHandler) {
            String extractorName = name + "$extractor";
            if (c.channel().pipeline().context(extractorName) != null) {
                return;
            }
            c.channel().pipeline().addBefore(name, extractorName, (ChannelHandler)HTTP_EXTRACTOR);
            if (c.isPersistent()) {
                c.onTerminate().subscribe(null, null, () -> c.removeHandler(extractorName));
            }
        }
    }

    protected final boolean markSentHeaders() {
        return HTTP_STATE.compareAndSet(this, 0, 1);
    }

    protected final boolean markSentBody() {
        return HTTP_STATE.compareAndSet(this, 1, 2);
    }

    protected final boolean markSentHeaderAndBody() {
        return HTTP_STATE.compareAndSet(this, 0, 2);
    }

    protected abstract HttpMessage outboundHttpMessage();

    protected static final class PostHeadersNettyOutbound
    implements NettyOutbound,
    Consumer<Throwable>,
    Runnable {
        final Mono<Void> source;
        final HttpOperations<?, ?> parent;
        final ByteBuf msg;

        public PostHeadersNettyOutbound(Mono<Void> source, HttpOperations<?, ?> parent, @Nullable ByteBuf msg) {
            this.msg = msg;
            this.source = msg != null ? source.doOnError((Consumer)this).doOnCancel((Runnable)this) : source;
            this.parent = parent;
        }

        @Override
        public void run() {
            if (this.msg != null && this.msg.refCnt() > 0) {
                this.msg.release();
            }
        }

        @Override
        public void accept(Throwable throwable) {
            if (this.msg != null && this.msg.refCnt() > 0) {
                this.msg.release();
            }
        }

        @Override
        public Mono<Void> then() {
            return this.source;
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.parent.alloc();
        }

        @Override
        public NettyOutbound options(Consumer<? super NettyPipeline.SendOptions> configurator) {
            return this.parent.options(configurator);
        }

        @Override
        public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
            return this.parent.send(dataStream);
        }

        @Override
        public NettyOutbound sendObject(Publisher<?> dataStream) {
            return this.parent.sendObject(dataStream);
        }

        @Override
        public NettyOutbound sendObject(Object message) {
            return this.parent.sendObject(message);
        }

        @Override
        public <S> NettyOutbound sendUsing(Callable<? extends S> sourceInput, BiFunction<? super Connection, ? super S, ?> mappedInput, Consumer<? super S> sourceCleanup) {
            return this.parent.sendUsing(sourceInput, mappedInput, sourceCleanup);
        }

        @Override
        public NettyOutbound withConnection(Consumer<? super Connection> withConnection) {
            return this.parent.withConnection(withConnection);
        }
    }
}

