/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientConfiguration;
import reactor.netty.http.client.HttpClientOperator;
import reactor.netty.tcp.TcpClient;

final class HttpClientCookieWhen
extends HttpClientOperator
implements Function<Bootstrap, Bootstrap> {
    final Function<? super Cookie, Mono<? extends Cookie>> cookie;
    final String name;

    HttpClientCookieWhen(HttpClient client, String name, Function<? super Cookie, Mono<? extends Cookie>> cookie) {
        super(client);
        this.cookie = Objects.requireNonNull(cookie, "cookie");
        this.name = Objects.requireNonNull(name, "name");
    }

    @Override
    protected TcpClient tcpConfiguration() {
        return this.source.tcpConfiguration().bootstrap(this);
    }

    @Override
    public Bootstrap apply(Bootstrap bootstrap) {
        HttpClientConfiguration.deferredConf(bootstrap, conf -> this.cookie.apply((Cookie)new DefaultCookie(this.name, "")).map(c -> HttpClientCookieWhen.cookie(conf, c)));
        return bootstrap;
    }

    static HttpClientConfiguration cookie(HttpClientConfiguration conf, Cookie c) {
        if (!c.value().isEmpty()) {
            if (conf.headers == null) {
                conf.headers = new DefaultHttpHeaders();
            }
            conf.headers.add((CharSequence)HttpHeaderNames.COOKIE, (Object)conf.cookieEncoder.encode(c));
        }
        return conf;
    }
}

