/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import reactor.netty.http.server.HttpServerRequest;

final class HttpPredicate
implements Predicate<HttpServerRequest>,
Function<Object, Map<String, String>> {
    final HttpVersion protocol;
    final HttpMethod method;
    final String uri;
    final UriPathTemplate template;

    public static Predicate<HttpServerRequest> delete(String uri) {
        return HttpPredicate.http(uri, null, HttpMethod.DELETE);
    }

    public static Predicate<HttpServerRequest> get(String uri) {
        return HttpPredicate.http(uri, null, HttpMethod.GET);
    }

    public static Predicate<HttpServerRequest> head(String uri) {
        return HttpPredicate.http(uri, null, HttpMethod.HEAD);
    }

    public static Predicate<HttpServerRequest> http(String uri, @Nullable HttpVersion protocol, HttpMethod method) {
        if (null == uri) {
            return null;
        }
        return new HttpPredicate(uri, protocol, method);
    }

    public static Predicate<HttpServerRequest> options(String uri) {
        return HttpPredicate.http(uri, null, HttpMethod.OPTIONS);
    }

    public static Predicate<HttpServerRequest> post(String uri) {
        return HttpPredicate.http(uri, null, HttpMethod.POST);
    }

    public static Predicate<HttpServerRequest> prefix(String prefix) {
        return HttpPredicate.prefix(prefix, HttpMethod.GET);
    }

    public static Predicate<HttpServerRequest> prefix(String prefix, HttpMethod method) {
        Objects.requireNonNull(prefix, "Prefix must be provided");
        String target = prefix.startsWith("/") ? prefix : "/".concat(prefix);
        return new HttpPrefixPredicate(target, method);
    }

    public static Predicate<HttpServerRequest> put(String uri) {
        return HttpPredicate.http(uri, null, HttpMethod.PUT);
    }

    public HttpPredicate(String uri) {
        this(uri, null, null);
    }

    public HttpPredicate(String uri, @Nullable HttpVersion protocol, @Nullable HttpMethod method) {
        this.protocol = protocol;
        this.uri = uri;
        this.method = method;
        this.template = uri != null ? new UriPathTemplate(uri) : null;
    }

    @Override
    public Map<String, String> apply(Object key) {
        if (this.template == null) {
            return null;
        }
        Map<String, String> headers = this.template.match(key.toString());
        if (null != headers && !headers.isEmpty()) {
            return headers;
        }
        return null;
    }

    @Override
    public final boolean test(HttpServerRequest key) {
        return !(this.protocol != null && !this.protocol.equals((Object)key.version()) || this.method != null && !this.method.equals((Object)key.method()) || this.template != null && !this.template.matches(key.uri()));
    }

    static final class HttpPrefixPredicate
    implements Predicate<HttpServerRequest> {
        final HttpMethod method;
        final String prefix;

        public HttpPrefixPredicate(String prefix, HttpMethod method) {
            this.prefix = prefix;
            this.method = method;
        }

        @Override
        public boolean test(HttpServerRequest key) {
            return (this.method == null || this.method.equals((Object)key.method())) && key.uri().startsWith(this.prefix);
        }
    }

    static final class TemplateInfo {
        private final List<String> variableNames;
        private final Pattern pattern;

        private TemplateInfo(List<String> vars, Pattern pattern) {
            this.variableNames = vars;
            this.pattern = pattern;
        }

        static TemplateInfo parse(String uriTemplate) {
            int level = 0;
            ArrayList<String> variableNames = new ArrayList<String>();
            StringBuilder pattern = new StringBuilder();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < uriTemplate.length(); ++i) {
                char c = uriTemplate.charAt(i);
                if (c == '{') {
                    if (++level == 1) {
                        pattern.append(builder.length() > 0 ? Pattern.quote(builder.toString()) : "");
                        builder = new StringBuilder();
                        continue;
                    }
                } else if (c == '}' && --level == 0) {
                    String variable = builder.toString();
                    int idx = variable.indexOf(58);
                    if (idx == -1) {
                        pattern.append("([^/]*)");
                        variableNames.add(variable);
                    } else {
                        if (idx + 1 == variable.length()) {
                            throw new IllegalArgumentException("No custom regular expression specified after ':' in \"" + variable + "\"");
                        }
                        String regex = variable.substring(idx + 1);
                        pattern.append('(');
                        pattern.append(regex);
                        pattern.append(')');
                        variableNames.add(variable.substring(0, idx));
                    }
                    builder = new StringBuilder();
                    continue;
                }
                builder.append(c);
            }
            if (builder.length() > 0) {
                pattern.append(Pattern.quote(builder.toString()));
            }
            return new TemplateInfo(variableNames, Pattern.compile(pattern.toString()));
        }
    }

    static final class UriPathTemplate
    implements Serializable {
        private final String uriTemplate;
        private final List<String> variableNames;
        private final Pattern matchPattern;

        UriPathTemplate(String uriTemplate) {
            this.uriTemplate = Objects.requireNonNull(uriTemplate, "'uriTemplate' must not be null");
            TemplateInfo info = TemplateInfo.parse(UriPathTemplate.filterQueryParams(uriTemplate));
            this.variableNames = Collections.unmodifiableList(info.variableNames);
            this.matchPattern = info.pattern;
        }

        boolean matches(@Nullable String uri) {
            if (uri == null) {
                return false;
            }
            uri = UriPathTemplate.filterQueryParams(uri);
            Matcher matcher = this.matchPattern.matcher(uri);
            return matcher.matches();
        }

        Map<String, String> match(String uri) {
            Objects.requireNonNull(uri, "'uri' must not be null");
            uri = UriPathTemplate.filterQueryParams(uri);
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.variableNames.size());
            Matcher matcher = this.matchPattern.matcher(uri);
            if (matcher.find()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String name = this.variableNames.get(i - 1);
                    String value = matcher.group(i);
                    result.put(name, value);
                }
            }
            return result;
        }

        public String toString() {
            return this.uriTemplate;
        }

        static String filterQueryParams(String uri) {
            int hasQuery = uri.lastIndexOf("?");
            if (hasQuery != -1) {
                return uri.substring(0, hasQuery);
            }
            return uri;
        }
    }
}

