/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.time.Duration;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerOperations;

final class HttpServerMetricsHandler
extends ChannelDuplexHandler {
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    String uri;
    String method;
    final HttpServerMetricsRecorder recorder;

    HttpServerMetricsHandler(HttpServerMetricsRecorder recorder) {
        this.recorder = recorder;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpResponse) {
            if (((HttpResponse)msg).status().equals((Object)HttpResponseStatus.CONTINUE)) {
                ctx.write(msg, promise);
                return;
            }
            this.dataSentTime = System.currentTimeMillis();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataSent += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataSent += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            promise.addListener(future -> {
                ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
                if (channelOps instanceof HttpServerOperations) {
                    HttpServerOperations ops = (HttpServerOperations)channelOps;
                    this.recorder.recordDataSentTime(ops.uri(), ops.method().name(), ops.status().codeAsText().toString(), Duration.ofMillis(System.currentTimeMillis() - this.dataSentTime));
                    if (this.dataReceivedTime != 0L) {
                        this.recorder.recordResponseTime(ops.uri(), ops.method().name(), ops.status().codeAsText().toString(), Duration.ofMillis(System.currentTimeMillis() - this.dataReceivedTime));
                    } else {
                        this.recorder.recordDataSentTime(ops.uri(), ops.method().name(), ops.status().codeAsText().toString(), Duration.ofMillis(System.currentTimeMillis() - this.dataSentTime));
                    }
                    this.recorder.recordDataSent(ops.remoteAddress(), ops.uri(), this.dataSent);
                    this.dataSent = 0L;
                }
            });
        }
        super.write(ctx, msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            this.dataReceivedTime = System.currentTimeMillis();
            HttpRequest request = (HttpRequest)msg;
            this.uri = request.uri();
            this.method = request.method().name();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataReceived += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataReceived += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            this.recorder.recordDataReceivedTime(this.uri, this.method, Duration.ofMillis(System.currentTimeMillis() - this.dataReceivedTime));
            this.recorder.recordDataReceived(ctx.channel().remoteAddress(), this.uri, this.dataReceived);
            this.dataReceived = 0L;
        }
        super.channelRead(ctx, msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.uri != null) {
            this.recorder.incrementErrorsCount(ctx.channel().remoteAddress(), this.uri);
        }
        super.exceptionCaught(ctx, cause);
    }
}

