/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.group.ChannelGroup;
import java.util.Objects;
import java.util.function.Function;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerConfiguration;
import reactor.netty.http.server.HttpServerOperator;
import reactor.netty.tcp.TcpServer;

final class HttpServerChannelGroup
extends HttpServerOperator
implements ConnectionObserver,
Function<ServerBootstrap, ServerBootstrap> {
    final ChannelGroup channelGroup;

    HttpServerChannelGroup(HttpServer source, ChannelGroup channelGroup) {
        super(source);
        this.channelGroup = Objects.requireNonNull(channelGroup, "channelGroup");
    }

    @Override
    protected TcpServer tcpConfiguration() {
        return this.source.tcpConfiguration().bootstrap(this);
    }

    @Override
    public void onStateChange(Connection connection, ConnectionObserver.State newState) {
        if (newState == ConnectionObserver.State.CONNECTED) {
            this.channelGroup.add((Object)connection.channel());
        }
    }

    @Override
    public ServerBootstrap apply(ServerBootstrap b) {
        HttpServerConfiguration.channelGroup(b, this.channelGroup);
        ConnectionObserver observer = BootstrapHandlers.childConnectionObserver(b);
        BootstrapHandlers.childConnectionObserver(b, observer.then(this));
        return b;
    }
}

