/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Scheduler;
import reactor.rabbitmq.ChannelPool;
import reactor.rabbitmq.Utils;

public class SenderOptions {
    private ConnectionFactory connectionFactory = ((Supplier<ConnectionFactory>)() -> {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.useNio();
        return connectionFactory;
    }).get();
    private Mono<? extends Connection> connectionMono;
    private Mono<? extends Channel> channelMono;
    private BiConsumer<SignalType, Channel> channelCloseHandler;
    private Scheduler resourceManagementScheduler;
    private Scheduler connectionSubscriptionScheduler;
    private Mono<? extends Channel> resourceManagementChannelMono;

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public SenderOptions connectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        return this;
    }

    public Scheduler getResourceManagementScheduler() {
        return this.resourceManagementScheduler;
    }

    public SenderOptions resourceManagementScheduler(Scheduler resourceManagementScheduler) {
        this.resourceManagementScheduler = resourceManagementScheduler;
        return this;
    }

    public Scheduler getConnectionSubscriptionScheduler() {
        return this.connectionSubscriptionScheduler;
    }

    public SenderOptions connectionSubscriptionScheduler(Scheduler connectionSubscriptionScheduler) {
        this.connectionSubscriptionScheduler = connectionSubscriptionScheduler;
        return this;
    }

    public SenderOptions connectionSupplier(Utils.ExceptionFunction<ConnectionFactory, ? extends Connection> function) {
        return this.connectionSupplier(this.connectionFactory, function);
    }

    public SenderOptions connectionSupplier(ConnectionFactory connectionFactory, Utils.ExceptionFunction<ConnectionFactory, ? extends Connection> function) {
        this.connectionMono = Mono.fromCallable(() -> (Connection)function.apply(connectionFactory));
        return this;
    }

    public SenderOptions connectionMono(Mono<? extends Connection> connectionMono) {
        this.connectionMono = connectionMono;
        return this;
    }

    public Mono<? extends Connection> getConnectionMono() {
        return this.connectionMono;
    }

    public SenderOptions channelMono(Mono<? extends Channel> channelMono) {
        this.channelMono = channelMono;
        return this;
    }

    public Mono<? extends Channel> getChannelMono() {
        return this.channelMono;
    }

    public BiConsumer<SignalType, Channel> getChannelCloseHandler() {
        return this.channelCloseHandler;
    }

    public SenderOptions channelCloseHandler(BiConsumer<SignalType, Channel> channelCloseHandler) {
        this.channelCloseHandler = channelCloseHandler;
        return this;
    }

    public SenderOptions channelPool(ChannelPool channelPool) {
        this.channelMono = channelPool.getChannelMono();
        this.channelCloseHandler = channelPool.getChannelCloseHandler();
        return this;
    }

    public SenderOptions resourceManagementChannelMono(Mono<? extends Channel> resourceManagementChannelMono) {
        this.resourceManagementChannelMono = resourceManagementChannelMono;
        return this;
    }

    public Mono<? extends Channel> getResourceManagementChannelMono() {
        return this.resourceManagementChannelMono;
    }
}

