/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import java.util.Map;
import reactor.util.annotation.Nullable;

public class BindingSpecification {
    private String queue;
    private String exchange;
    private String routingKey;
    private Map<String, Object> arguments;

    public static BindingSpecification binding() {
        return new BindingSpecification();
    }

    public static BindingSpecification binding(String exchange, String routingKey, String queue) {
        return new BindingSpecification().exchange(exchange).routingKey(routingKey).queue(queue);
    }

    public BindingSpecification queue(String queue) {
        this.queue = queue;
        return this;
    }

    public BindingSpecification exchange(String exchange) {
        this.exchange = exchange;
        return this;
    }

    public BindingSpecification routingKey(String routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    public BindingSpecification arguments(@Nullable Map<String, Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    @Nullable
    public Map<String, Object> getArguments() {
        return this.arguments;
    }
}

