/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.selector;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import reactor.bus.selector.ObjectSelector;
import reactor.bus.selector.Selector;
import reactor.io.buffer.Buffer;

public class JsonPathSelector
extends ObjectSelector<Object, JsonPath> {
    private static ObjectMapper MAPPER = new ObjectMapper();
    private final ObjectMapper mapper;
    private final Configuration jsonPathConfig;

    public JsonPathSelector(ObjectMapper mapper, String jsonPath, Filter ... filters) {
        super(JsonPath.compile((String)jsonPath, (Predicate[])filters));
        this.mapper = mapper;
        this.jsonPathConfig = Configuration.builder().jsonProvider((JsonProvider)new Jackson2JsonProvider(mapper)).build();
    }

    public JsonPathSelector(String jsonPath, Filter ... filters) {
        this(MAPPER, jsonPath, filters);
    }

    public static Selector J(String jsonPath, Filter ... filters) {
        return JsonPathSelector.jsonPathSelector(jsonPath, filters);
    }

    public static Selector jsonPathSelector(String jsonPath, Filter ... filters) {
        return new JsonPathSelector(jsonPath, filters);
    }

    @Override
    public boolean matches(Object key) {
        if (null == key) {
            return false;
        }
        Object result = this.read(key);
        if (null == result) {
            return false;
        }
        Class<?> type = result.getClass();
        if (Collection.class.isAssignableFrom(type)) {
            return ((Collection)result).size() > 0;
        }
        if (Map.class.isAssignableFrom(type)) {
            return ((Map)result).size() > 0;
        }
        if (JsonNode.class.isAssignableFrom(type)) {
            return ((JsonNode)result).size() > 0;
        }
        return true;
    }

    private Object read(Object key) {
        Class<?> type = key.getClass();
        if (type == String.class) {
            return ((JsonPath)this.getObject()).read((String)key, this.jsonPathConfig);
        }
        if (type == byte[].class) {
            return ((JsonPath)this.getObject()).read(Buffer.wrap((byte[])((byte[])key)).asString(), this.jsonPathConfig);
        }
        if (type == Buffer.class) {
            return ((JsonPath)this.getObject()).read(((Buffer)key).asString(), this.jsonPathConfig);
        }
        if (JsonNode.class.isAssignableFrom(type)) {
            return ((JsonPath)this.getObject()).read(key, this.jsonPathConfig);
        }
        return ((JsonPath)this.getObject()).read(this.mapper.convertValue(key, Object.class), this.jsonPathConfig);
    }

    private static class Jackson2JsonProvider
    implements JsonProvider,
    MappingProvider {
        private final ObjectMapper mapper;

        private Jackson2JsonProvider(ObjectMapper mapper) {
            this.mapper = mapper;
        }

        public Object parse(String json) throws InvalidJsonException {
            try {
                return this.mapper.readValue(json, Object.class);
            }
            catch (IOException e) {
                throw new InvalidJsonException(e.getMessage(), (Throwable)e);
            }
        }

        public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
            try {
                return this.mapper.readValue((Reader)new InputStreamReader(jsonStream, charset), Object.class);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public String toJson(Object obj) {
            try {
                return this.mapper.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        public Object createMap() {
            return new HashMap();
        }

        public Iterable createArray() {
            return new ArrayList();
        }

        public Object getArrayIndex(Object obj, int idx) {
            return this.getProperty(obj, idx);
        }

        public Object getArrayIndex(Object obj, int idx, boolean unwrap) {
            Object o = this.getProperty(obj, idx);
            if (o instanceof JsonNode && unwrap) {
                return this.unwrap((JsonNode)o);
            }
            return o;
        }

        public void setArrayIndex(Object array, int idx, Object newValue) {
            this.setProperty(array, idx, newValue);
        }

        public Object getMapValue(Object obj, String key) {
            return this.getProperty(obj, key);
        }

        public void removeProperty(Object obj, Object key) {
            this.setProperty(obj, key, null);
        }

        public <T> T map(Object source, Class<T> targetType, Configuration configuration) {
            return (T)this.mapper.convertValue(source, targetType);
        }

        public <T> T map(Object source, TypeRef<T> targetType, Configuration configuration) {
            if (targetType.getType() instanceof Class) {
                return (T)this.mapper.convertValue(source, (Class)targetType.getType());
            }
            throw new IllegalArgumentException("Cannot convert to " + targetType);
        }

        public boolean isArray(Object obj) {
            return obj instanceof List || obj instanceof ArrayNode;
        }

        public boolean isMap(Object obj) {
            return obj instanceof Map || obj instanceof ObjectNode;
        }

        public int length(Object obj) {
            if (obj instanceof List) {
                return ((List)obj).size();
            }
            if (obj instanceof Map) {
                return ((Map)obj).size();
            }
            if (obj instanceof ArrayNode) {
                return ((ArrayNode)obj).size();
            }
            if (obj instanceof ObjectNode) {
                return ((ObjectNode)obj).size();
            }
            return this.length(this.mapper.convertValue(obj, JsonNode.class));
        }

        public Iterable<Object> toIterable(Object obj) {
            if (obj instanceof List || obj instanceof JsonNode) {
                return (Iterable)obj;
            }
            if (obj instanceof Map) {
                return ((Map)obj).values();
            }
            return this.toIterable(this.mapper.convertValue(obj, JsonNode.class));
        }

        public Collection<String> getPropertyKeys(Object obj) {
            if (obj instanceof Map) {
                return ((Map)obj).keySet();
            }
            if (obj instanceof List) {
                List l = (List)obj;
                ArrayList<String> keys = new ArrayList<String>(l.size());
                for (Object o : l) {
                    keys.add(String.valueOf(o));
                }
                return keys;
            }
            if (obj instanceof ObjectNode) {
                ObjectNode node = (ObjectNode)obj;
                ArrayList<String> keys = new ArrayList<String>(node.size());
                Iterator iter = node.fieldNames();
                while (iter.hasNext()) {
                    keys.add((String)iter.next());
                }
                return keys;
            }
            if (obj instanceof ArrayNode) {
                ArrayNode node = (ArrayNode)obj;
                ArrayList<String> keys = new ArrayList<String>(node.size());
                int len = node.size();
                for (int i = 0; i < len; ++i) {
                    keys.add(String.valueOf(node.get(i)));
                }
                return keys;
            }
            return this.getPropertyKeys(this.mapper.convertValue(obj, JsonNode.class));
        }

        public void setProperty(Object obj, Object key, Object value) {
            if (obj instanceof Map) {
                ((Map)obj).put(key, value);
            } else if (obj instanceof List) {
                int idx = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
                ((List)obj).add(idx, value);
            } else if (obj instanceof ObjectNode) {
                ((ObjectNode)obj).set(key.toString(), (JsonNode)value);
            } else if (obj instanceof ArrayNode) {
                int idx = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
                ((ArrayNode)obj).set(idx, (JsonNode)value);
            } else {
                this.setProperty(this.mapper.convertValue(obj, JsonNode.class), key, value);
            }
        }

        private Object getProperty(Object obj, Object key) {
            if (obj instanceof Map) {
                return ((Map)obj).get(key);
            }
            if (obj instanceof List) {
                int idx = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
                return ((List)obj).get(idx);
            }
            if (obj instanceof ObjectNode) {
                return this.unwrap(((ObjectNode)obj).get(key.toString()));
            }
            if (obj instanceof ArrayNode) {
                int idx = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
                return this.unwrap(((ArrayNode)obj).get(idx));
            }
            return this.getProperty(this.mapper.convertValue(obj, JsonNode.class), key);
        }

        private Object unwrap(JsonNode node) {
            if (node.isValueNode()) {
                if (node.isNumber()) {
                    return node.numberValue();
                }
                if (node.isTextual()) {
                    return node.asText();
                }
                return node;
            }
            return node;
        }
    }
}

