/*
 * Decompiled with CFR 0.152.
 */
package reactor.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import reactor.bus.batcher.Operation;
import reactor.bus.batcher.OperationBatcher;
import reactor.bus.batcher.spec.OperationBatcherSpec;
import reactor.fn.Consumer;
import reactor.fn.Supplier;

public class AsyncAppender
extends ContextAwareBase
implements Appender<ILoggingEvent>,
AppenderAttachable<ILoggingEvent> {
    private final AppenderAttachableImpl<ILoggingEvent> aai = new AppenderAttachableImpl();
    private final FilterAttachableImpl<ILoggingEvent> fai = new FilterAttachableImpl();
    private final AtomicReference<Appender<ILoggingEvent>> delegate = new AtomicReference();
    private String name;
    private OperationBatcher<LogEvent> processor;
    private long backlog = 0x100000L;
    private boolean includeCallerData = false;
    private boolean started = false;

    public long getBacklog() {
        return this.backlog;
    }

    public void setBacklog(long backlog) {
        this.backlog = backlog;
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        this.includeCallerData = includeCallerData;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void doAppend(ILoggingEvent evt) throws LogbackException {
        if (this.getFilterChainDecision(evt) == FilterReply.DENY) {
            return;
        }
        evt.prepareForDeferredProcessing();
        if (this.includeCallerData) {
            evt.getCallerData();
        }
        try {
            this.queueLoggingEvent(evt);
        }
        catch (Throwable t) {
            this.addError(t.getMessage(), t);
        }
    }

    public void start() {
        this.startDelegateAppender();
        this.processor = new OperationBatcherSpec().dataSupplier((Supplier)new Supplier<LogEvent>(){

            public LogEvent get() {
                return new LogEvent();
            }
        }).multiThreadedProducer().dataBufferSize((int)this.backlog).when(Throwable.class, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                AsyncAppender.this.addError(throwable.getMessage(), throwable);
            }
        }).consume((Consumer)new Consumer<LogEvent>(){

            public void accept(LogEvent evt) {
                AsyncAppender.this.loggingEventDequeued(evt.event);
            }
        }).get();
        try {
            this.doStart();
        }
        catch (Throwable t) {
            this.addError(t.getMessage(), t);
        }
        finally {
            this.started = true;
        }
    }

    private void startDelegateAppender() {
        Appender<ILoggingEvent> delegateAppender = this.delegate.get();
        if (null != delegateAppender && !delegateAppender.isStarted()) {
            delegateAppender.start();
        }
    }

    public void stop() {
        if (null != this.delegate.get()) {
            this.delegate.get().stop();
        }
        this.aai.detachAndStopAllAppenders();
        this.processor.shutdown();
        try {
            this.doStop();
        }
        catch (Throwable t) {
            this.addError(t.getMessage(), t);
        }
        finally {
            this.started = false;
        }
    }

    public void addFilter(Filter<ILoggingEvent> newFilter) {
        this.fai.addFilter(newFilter);
    }

    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    public List<Filter<ILoggingEvent>> getCopyOfAttachedFiltersList() {
        return this.fai.getCopyOfAttachedFiltersList();
    }

    public FilterReply getFilterChainDecision(ILoggingEvent event) {
        return this.fai.getFilterChainDecision((Object)event);
    }

    public void addAppender(Appender<ILoggingEvent> newAppender) {
        if (!this.delegate.compareAndSet(null, newAppender)) {
            throw new IllegalArgumentException(this.delegate.get() + " already attached.");
        }
        this.aai.addAppender(newAppender);
    }

    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender<ILoggingEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender<ILoggingEvent> appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    protected AppenderAttachableImpl<ILoggingEvent> getAppenderImpl() {
        return this.aai;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void queueLoggingEvent(ILoggingEvent evt) {
        if (null != this.delegate.get()) {
            Operation op = this.processor.prepare();
            ((LogEvent)op.get()).event = evt;
            op.commit();
        }
    }

    protected void loggingEventDequeued(ILoggingEvent evt) {
        this.aai.appendLoopOnAppenders((Object)evt);
    }

    private static class LogEvent {
        ILoggingEvent event;

        private LogEvent() {
        }
    }
}

