/*
 * Decompiled with CFR 0.152.
 */
package reactor.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.processor.RingBufferProcessor;

public class AsyncAppender
extends ContextAwareBase
implements Appender<ILoggingEvent>,
AppenderAttachable<ILoggingEvent>,
Subscriber<ILoggingEvent> {
    private final AppenderAttachableImpl<ILoggingEvent> aai = new AppenderAttachableImpl();
    private final FilterAttachableImpl<ILoggingEvent> fai = new FilterAttachableImpl();
    private final AtomicReference<Appender<ILoggingEvent>> delegate = new AtomicReference();
    private String name;
    private Processor<ILoggingEvent, ILoggingEvent> processor;
    private int backlog = 0x100000;
    private boolean includeCallerData = false;
    private boolean started = false;

    public long getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        this.includeCallerData = includeCallerData;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void doAppend(ILoggingEvent evt) throws LogbackException {
        if (this.getFilterChainDecision(evt) == FilterReply.DENY) {
            return;
        }
        evt.prepareForDeferredProcessing();
        if (this.includeCallerData) {
            evt.getCallerData();
        }
        try {
            this.queueLoggingEvent(evt);
        }
        catch (Throwable t) {
            this.addError(t.getMessage(), t);
        }
    }

    public void start() {
        this.startDelegateAppender();
        this.processor = RingBufferProcessor.share((String)"logger", (int)this.backlog, (boolean)false);
        this.processor.subscribe((Subscriber)this);
    }

    public void onSubscribe(Subscription s) {
        try {
            this.doStart();
        }
        catch (Throwable t) {
            this.addError(t.getMessage(), t);
        }
        finally {
            this.started = true;
            s.request(Long.MAX_VALUE);
        }
    }

    public void onNext(ILoggingEvent iLoggingEvent) {
        this.aai.appendLoopOnAppenders((Object)iLoggingEvent);
    }

    public void onError(Throwable t) {
        this.addError(t.getMessage(), t);
    }

    public void onComplete() {
        try {
            this.doStop();
        }
        catch (Throwable t) {
            this.addError(t.getMessage(), t);
        }
        finally {
            this.started = false;
        }
    }

    private void startDelegateAppender() {
        Appender<ILoggingEvent> delegateAppender = this.delegate.get();
        if (null != delegateAppender && !delegateAppender.isStarted()) {
            delegateAppender.start();
        }
    }

    public void stop() {
        if (null != this.delegate.get()) {
            this.delegate.get().stop();
        }
        this.aai.detachAndStopAllAppenders();
        this.processor.onComplete();
    }

    public void addFilter(Filter<ILoggingEvent> newFilter) {
        this.fai.addFilter(newFilter);
    }

    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    public List<Filter<ILoggingEvent>> getCopyOfAttachedFiltersList() {
        return this.fai.getCopyOfAttachedFiltersList();
    }

    public FilterReply getFilterChainDecision(ILoggingEvent event) {
        return this.fai.getFilterChainDecision((Object)event);
    }

    public void addAppender(Appender<ILoggingEvent> newAppender) {
        if (!this.delegate.compareAndSet(null, newAppender)) {
            throw new IllegalArgumentException(this.delegate.get() + " already attached.");
        }
        this.aai.addAppender(newAppender);
    }

    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender<ILoggingEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender<ILoggingEvent> appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    protected AppenderAttachableImpl<ILoggingEvent> getAppenderImpl() {
        return this.aai;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void queueLoggingEvent(ILoggingEvent evt) {
        if (null != this.delegate.get()) {
            this.processor.onNext((Object)evt);
        }
    }
}

