/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import reactor.io.buffer.Buffer;
import reactor.io.codec.StringCodec;
import reactor.io.net.http.model.Status;
import reactor.io.net.impl.netty.http.NettyHttpServerHandler;

public class NettyHttpWSServerHandler<IN, OUT>
extends NettyHttpServerHandler<IN, OUT> {
    private final WebSocketServerHandshaker handshaker;
    private final boolean plainText;

    public NettyHttpWSServerHandler(String wsUrl, String protocols, NettyHttpServerHandler<IN, OUT> originalHandler) {
        super(originalHandler.getHandler(), originalHandler.getChannelStream());
        this.request = originalHandler.request;
        this.plainText = originalHandler.getChannelStream().getEncoder() instanceof StringCodec.StringEncoder;
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(wsUrl, protocols, true);
        this.handshaker = wsFactory.newHandshaker(this.request.getNettyRequest());
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)this.channelStream.delegate());
        } else {
            this.handshaker.handshake(this.channelStream.delegate(), this.request.getNettyRequest());
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object frame) throws Exception {
        if (CloseWebSocketFrame.class.equals(frame.getClass())) {
            this.handshaker.close(ctx.channel(), ((CloseWebSocketFrame)frame).retain());
            if (this.channelSubscription != null) {
                this.channelSubscription.onComplete();
                this.channelSubscription = null;
            }
            return;
        }
        if (PingWebSocketFrame.class.isAssignableFrom(frame.getClass())) {
            ctx.channel().write((Object)new PongWebSocketFrame(((PingWebSocketFrame)frame).content().retain()));
            return;
        }
        this.doRead(ctx, ((WebSocketFrame)frame).content());
    }

    @Override
    protected void writeLast(ChannelHandlerContext ctx) {
        ChannelFuture f = ctx.channel().writeAndFlush((Object)new CloseWebSocketFrame());
        if (!this.request.isKeepAlive() || this.request.responseStatus() != Status.OK) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    @Override
    protected ChannelFuture doOnWrite(Object data, ChannelHandlerContext ctx) {
        if (data.getClass().equals(Buffer.class)) {
            if (!this.plainText) {
                return ctx.write((Object)new BinaryWebSocketFrame(NettyHttpWSServerHandler.convertBufferToByteBuff(ctx, (Buffer)data)));
            }
            return ctx.write((Object)new TextWebSocketFrame(NettyHttpWSServerHandler.convertBufferToByteBuff(ctx, (Buffer)data)));
        }
        return ctx.write(data);
    }
}

