/*
 * Decompiled with CFR 0.152.
 */
package reactor.tools.agent;

import java.util.concurrent.atomic.AtomicBoolean;
import reactor.tools.shaded.net.bytebuddy.jar.asm.Label;
import reactor.tools.shaded.net.bytebuddy.jar.asm.MethodVisitor;
import reactor.tools.shaded.net.bytebuddy.jar.asm.Type;

class CallSiteInfoAddingMethodVisitor
extends MethodVisitor {
    static final String ADD_CALLSITE_INFO_METHOD = "(Lorg/reactivestreams/Publisher;Ljava/lang/String;)Lorg/reactivestreams/Publisher;";
    final String currentMethod;
    final String currentClassName;
    final String currentSource;
    final AtomicBoolean changed;
    int currentLine = -1;

    static boolean isCorePublisher(String className) {
        switch (className) {
            case "reactor/core/publisher/Flux": 
            case "reactor/core/publisher/Mono": 
            case "reactor/core/publisher/ParallelFlux": 
            case "reactor/core/publisher/GroupedFlux": {
                return true;
            }
        }
        return false;
    }

    CallSiteInfoAddingMethodVisitor(MethodVisitor visitor, String currentClassName, String currentMethod, String currentSource, AtomicBoolean changed) {
        super(458752, visitor);
        this.currentMethod = currentMethod;
        this.currentClassName = currentClassName;
        this.currentSource = currentSource;
        this.changed = changed;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.currentLine = line;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        if (CallSiteInfoAddingMethodVisitor.isCorePublisher(owner)) {
            if ("checkpoint".equals(name)) {
                return;
            }
            String returnType = Type.getReturnType(descriptor).getInternalName();
            if (!returnType.startsWith("reactor/core/publisher/")) {
                return;
            }
            this.changed.set(true);
            String callSite = String.format("\t%s.%s\n\t%s.%s(%s:%d)\n", owner.replace("/", "."), name, this.currentClassName.replace("/", "."), this.currentMethod, this.currentSource, this.currentLine);
            super.visitLdcInsn(callSite);
            super.visitMethodInsn(184, "reactor/core/publisher/Hooks", "addCallSiteInfo", ADD_CALLSITE_INFO_METHOD, false);
            super.visitTypeInsn(192, returnType);
        }
    }
}

