/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.messaging.factory.net;

import java.net.InetSocketAddress;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.GenericMessage;
import reactor.Environment;
import reactor.core.support.Assert;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.codec.Codec;
import reactor.io.codec.DelimitedCodec;
import reactor.io.codec.LengthFieldCodec;
import reactor.io.codec.StandardCodecs;
import reactor.io.net.ChannelStream;
import reactor.io.net.NetStreams;
import reactor.io.net.Server;
import reactor.io.net.Spec;
import reactor.io.net.codec.syslog.SyslogCodec;
import reactor.io.net.http.HttpServer;
import reactor.io.net.impl.netty.tcp.NettyTcpServer;
import reactor.io.net.impl.netty.udp.NettyDatagramServer;
import reactor.io.net.udp.DatagramServer;

public class NetServerFactoryBean<IN, OUT, CONN extends ChannelStream<IN, OUT>>
implements FactoryBean<Server<IN, OUT, CONN>>,
SmartLifecycle {
    private final ReentrantLock startLock = new ReentrantLock();
    private final Environment env;
    private volatile boolean started = false;
    private int phase = 0;
    private boolean autoStartup = true;
    private Class<? extends Server> serverImpl;
    private Server<IN, OUT, CONN> server;
    private String dispatcher;
    private String host = null;
    private int port = 3000;
    private Codec codec = StandardCodecs.BYTE_ARRAY_CODEC;
    private String framing = "delimited";
    private String delimiter = "LF";
    private int lengthFieldLength = 4;
    private String transport = "tcp";
    private MessageHandler messageHandler;

    public NetServerFactoryBean(Environment env) {
        this.env = env;
    }

    public NetServerFactoryBean setDispatcher(String dispatcher) {
        this.dispatcher = dispatcher;
        return this;
    }

    public NetServerFactoryBean setPhase(int phase) {
        this.phase = phase;
        return this;
    }

    public NetServerFactoryBean setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
        return this;
    }

    public NetServerFactoryBean setHost(String host) {
        Assert.notNull((Object)host, (String)"Host cannot be null.");
        this.host = host;
        return this;
    }

    public NetServerFactoryBean setPort(int port) {
        Assert.isTrue((port > 0 ? 1 : 0) != 0, (String)"Port must be greater than 0");
        this.port = port;
        return this;
    }

    public NetServerFactoryBean setCodec(String codec) {
        if ("bytes".equals(codec)) {
            this.codec = StandardCodecs.BYTE_ARRAY_CODEC;
        } else if ("string".equals(codec)) {
            this.codec = StandardCodecs.STRING_CODEC;
        } else if ("syslog".equals(codec)) {
            this.codec = new SyslogCodec();
        } else {
            throw new IllegalArgumentException("Codec '" + codec + "' not recognized.");
        }
        return this;
    }

    public NetServerFactoryBean setFraming(String framing) {
        Assert.isTrue(("delimited".equals(framing) || "length".equals(framing) ? 1 : 0) != 0);
        this.framing = framing;
        return this;
    }

    public NetServerFactoryBean setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public NetServerFactoryBean setLengthFieldLength(int lengthFieldLength) {
        this.lengthFieldLength = lengthFieldLength;
        return this;
    }

    public NetServerFactoryBean setTransport(String transport) {
        if ("tcp".equals(transport)) {
            this.serverImpl = NettyTcpServer.class;
        } else if ("udp".equals(transport)) {
            this.serverImpl = NettyDatagramServer.class;
        } else {
            throw new IllegalArgumentException("Transport must be either 'tcp' or 'udp'");
        }
        this.transport = transport;
        return this;
    }

    public NetServerFactoryBean setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        this.startLock.lock();
        try {
            this.server.shutdown();
            this.started = false;
        }
        finally {
            this.startLock.unlock();
            if (null != callback) {
                callback.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.startLock.lock();
        try {
            this.server.start();
            this.started = true;
        }
        finally {
            this.startLock.unlock();
        }
    }

    public void stop() {
        this.stop(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        this.startLock.lock();
        try {
            boolean bl = this.started;
            return bl;
        }
        finally {
            this.startLock.unlock();
        }
    }

    public int getPhase() {
        return this.phase;
    }

    public Server<IN, OUT, CONN> getObject() throws Exception {
        if (null == this.server) {
            InetSocketAddress bindAddress = null == this.host ? InetSocketAddress.createUnresolved("0.0.0.0", this.port) : new InetSocketAddress(this.host, this.port);
            Object framedCodec = "delimited".equals(this.framing) ? ("LF".equals(this.delimiter) ? new DelimitedCodec(this.codec) : ("CR".equals(this.delimiter) ? new DelimitedCodec(13, true, this.codec) : this.codec)) : ("length".equals(this.framing) ? new LengthFieldCodec(this.lengthFieldLength, this.codec) : this.codec);
            final Function commonSpec = new Function<Spec.Server<IN, OUT, CONN, ?, ?>, Spec.Server<IN, OUT, CONN, ?, ?>>((Codec)framedCodec, bindAddress){
                final /* synthetic */ Codec val$framedCodec;
                final /* synthetic */ InetSocketAddress val$bindAddress;
                {
                    this.val$framedCodec = codec;
                    this.val$bindAddress = inetSocketAddress;
                }

                public Spec.Server<IN, OUT, CONN, ?, ?> apply(Spec.Server<IN, OUT, CONN, ?, ?> s) {
                    if (NetServerFactoryBean.this.dispatcher != null) {
                        s.dispatcher(NetServerFactoryBean.this.dispatcher);
                    }
                    return ((Spec.Server)s.env(NetServerFactoryBean.this.env)).codec(this.val$framedCodec).listen(this.val$bindAddress);
                }
            };
            if ("tcp".equals(this.transport)) {
                this.server = NetStreams.tcpServer(null == this.serverImpl ? NettyTcpServer.class : this.serverImpl, (Function)new Function<Spec.TcpServer<IN, OUT>, Spec.TcpServer<IN, OUT>>(){

                    public Spec.TcpServer<IN, OUT> apply(Spec.TcpServer<IN, OUT> spec) {
                        commonSpec.apply(spec);
                        return spec;
                    }
                });
            } else if ("udp".equals(this.transport)) {
                this.server = NetStreams.udpServer(null == this.serverImpl ? DatagramServer.class : this.serverImpl, (Function)new Function<Spec.DatagramServer<IN, OUT>, Spec.DatagramServer<IN, OUT>>(){

                    public Spec.DatagramServer<IN, OUT> apply(Spec.DatagramServer<IN, OUT> spec) {
                        commonSpec.apply(spec);
                        return spec;
                    }
                });
            } else if ("http".equals(this.transport)) {
                this.server = NetStreams.httpServer(null == this.serverImpl ? HttpServer.class : this.serverImpl, (Function)new Function<Spec.HttpServer<IN, OUT>, Spec.HttpServer<IN, OUT>>(){

                    public Spec.HttpServer<IN, OUT> apply(Spec.HttpServer<IN, OUT> spec) {
                        commonSpec.apply(spec);
                        return spec;
                    }
                });
            } else {
                throw new IllegalArgumentException(this.transport + " not recognized as a valid transport type.");
            }
            if (this.server != null) {
                this.server.subscribe(new Subscriber<CONN>(){
                    Subscription s;

                    public void onSubscribe(Subscription s) {
                        s.request(Long.MAX_VALUE);
                        this.s = s;
                    }

                    public void onNext(CONN ch) {
                        ch.consume(new Consumer<IN>(){

                            public void accept(IN o) {
                                if (null == NetServerFactoryBean.this.messageHandler) {
                                    return;
                                }
                                GenericMessage msg = new GenericMessage(o);
                                NetServerFactoryBean.this.messageHandler.handleMessage((Message)msg);
                            }
                        });
                    }

                    public void onError(Throwable t) {
                        if (this.s != null) {
                            this.s.cancel();
                        }
                    }

                    public void onComplete() {
                        if (this.s != null) {
                            this.s.cancel();
                        }
                    }
                });
            }
        }
        return this.server;
    }

    public Class<?> getObjectType() {
        return Server.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

