/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.webmvc;

import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import reactor.fn.Consumer;
import reactor.rx.Promise;

public class PromiseHandlerMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    public boolean supportsReturnType(MethodParameter returnType) {
        return Promise.class.isAssignableFrom(returnType.getParameterType());
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        final DeferredResult deferredResult = new DeferredResult();
        ((Promise)returnValue).onSuccess(new Consumer(){

            public void accept(Object o) {
                deferredResult.setResult(o);
            }
        }).onError((Consumer)new Consumer<Throwable>(){

            public void accept(Throwable t) {
                deferredResult.setErrorResult((Object)t);
            }
        });
        WebAsyncUtils.getAsyncManager((WebRequest)webRequest).startDeferredResultProcessing(deferredResult, new Object[]{mavContainer});
    }
}

