/*
 * Decompiled with CFR 0.152.
 */
package reactor.blockhound;

import java.util.function.Consumer;
import java.util.function.Predicate;

class BlockHoundRuntime {
    static volatile Consumer<Object[]> blockingMethodConsumer;
    static volatile Predicate<Thread> threadPredicate;
    static final ThreadLocal<Boolean> IS_ALLOWED;

    BlockHoundRuntime() {
    }

    static void checkBlocking(String internalClassName, String methodName, int modifiers) {
        if (Boolean.FALSE == IS_ALLOWED.get()) {
            blockingMethodConsumer.accept(new Object[]{internalClassName.replace("/", "."), methodName, modifiers});
        }
    }

    static {
        IS_ALLOWED = ThreadLocal.withInitial(() -> {
            if (threadPredicate.test(Thread.currentThread())) {
                return false;
            }
            return null;
        });
    }
}

