/*
 * Decompiled with CFR 0.152.
 */
package reactor.blockhound;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import reactor.blockhound.BlockHoundRuntime;
import reactor.blockhound.shaded.net.bytebuddy.agent.builder.AgentBuilder;
import reactor.blockhound.shaded.net.bytebuddy.asm.Advice;
import reactor.blockhound.shaded.net.bytebuddy.asm.AsmVisitorWrapper;
import reactor.blockhound.shaded.net.bytebuddy.description.annotation.AnnotationDescription;
import reactor.blockhound.shaded.net.bytebuddy.description.method.ParameterDescription;
import reactor.blockhound.shaded.net.bytebuddy.description.type.TypeDescription;
import reactor.blockhound.shaded.net.bytebuddy.dynamic.DynamicType;
import reactor.blockhound.shaded.net.bytebuddy.utility.JavaModule;

class AllowancesByteBuddyTransformer
implements AgentBuilder.Transformer {
    private Map<String, Map<String, Boolean>> allowances;

    AllowancesByteBuddyTransformer(Map<String, Map<String, Boolean>> allowances) {
        this.allowances = allowances;
    }

    @Override
    public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
        Map<String, Boolean> methods = this.allowances.get(typeDescription.getName());
        if (methods == null) {
            return builder;
        }
        AsmVisitorWrapper.ForDeclaredMethods advice = Advice.withCustomMapping().bind(new AllowedArgument.Factory(methods)).to(AllowAdvice.class).on(method -> methods.containsKey(method.getInternalName()));
        return builder.visit(advice);
    }

    static class AllowAdvice {
        AllowAdvice() {
        }

        @Advice.OnMethodEnter
        static BlockHoundRuntime.State onEnter(@AllowedArgument boolean allowed) {
            BlockHoundRuntime.State previous = BlockHoundRuntime.STATE.get();
            if (previous == null) {
                return null;
            }
            if (previous.isAllowed() == allowed) {
                return null;
            }
            previous.setAllowed(allowed);
            return previous;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class)
        static void onExit(@Advice.Enter BlockHoundRuntime.State previousState, @AllowedArgument boolean allowed) {
            if (previousState != null) {
                previousState.setAllowed(!allowed);
            }
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    static @interface AllowedArgument {

        public static class Factory
        implements Advice.OffsetMapping.Factory<AllowedArgument> {
            final Map<String, Boolean> methods;

            Factory(Map<String, Boolean> methods) {
                this.methods = methods;
            }

            @Override
            public Class<AllowedArgument> getAnnotationType() {
                return AllowedArgument.class;
            }

            @Override
            public Advice.OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<AllowedArgument> annotation, Advice.OffsetMapping.Factory.AdviceType adviceType) {
                return (instrumentedType, instrumentedMethod, assigner, argumentHandler, sort) -> {
                    boolean allowed = this.methods.get(instrumentedMethod.getInternalName());
                    return Advice.OffsetMapping.Target.ForStackManipulation.of(allowed);
                };
            }
        }
    }
}

