/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry.otelmodel;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramPointData;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PointDataImpl;
import java.util.List;

public class ExponentialHistogramPointDataImpl
extends PointDataImpl
implements ExponentialHistogramPointData {
    private final int scale;
    private final double sum;
    private final long count;
    private final long zeroCount;
    private final double min;
    private final double max;
    private final ExponentialHistogramBuckets positiveBuckets;
    private final ExponentialHistogramBuckets negativeBuckets;

    ExponentialHistogramPointDataImpl(int scale, double sum, long count, long zeroCount, double min, double max, ExponentialHistogramBuckets positiveBuckets, ExponentialHistogramBuckets negativeBuckets, long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars) {
        super(startEpochNanos, epochNanos, attributes, exemplars);
        this.scale = scale;
        this.sum = sum;
        this.count = count;
        this.zeroCount = zeroCount;
        this.min = min;
        this.max = max;
        this.positiveBuckets = positiveBuckets;
        this.negativeBuckets = negativeBuckets;
    }

    public int getScale() {
        return this.scale;
    }

    public double getSum() {
        return this.sum;
    }

    public long getCount() {
        return this.count;
    }

    public long getZeroCount() {
        return this.zeroCount;
    }

    public boolean hasMin() {
        return !Double.isNaN(this.min);
    }

    public double getMin() {
        return this.min;
    }

    public boolean hasMax() {
        return !Double.isNaN(this.max);
    }

    public double getMax() {
        return this.max;
    }

    public ExponentialHistogramBuckets getPositiveBuckets() {
        return this.positiveBuckets;
    }

    public ExponentialHistogramBuckets getNegativeBuckets() {
        return this.negativeBuckets;
    }
}

