/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry.otelmodel;

import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.DoublePointDataImpl;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusData;
import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.StateSetSnapshot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PrometheusStateSet
extends PrometheusData<DoublePointData>
implements SumData<DoublePointData> {
    private final List<DoublePointData> points = new ArrayList<DoublePointData>();

    public PrometheusStateSet(StateSetSnapshot snapshot, long currentTimeMillis) {
        super(MetricDataType.DOUBLE_SUM);
        for (StateSetSnapshot.StateSetDataPointSnapshot dataPoint : snapshot.getDataPoints()) {
            for (int i = 0; i < dataPoint.size(); ++i) {
                this.points.add(this.toOtelDataPoint(snapshot, dataPoint, i, currentTimeMillis));
            }
        }
    }

    public boolean isMonotonic() {
        return false;
    }

    public AggregationTemporality getAggregationTemporality() {
        return AggregationTemporality.CUMULATIVE;
    }

    public Collection<DoublePointData> getPoints() {
        return this.points;
    }

    private DoublePointData toOtelDataPoint(StateSetSnapshot snapshot, StateSetSnapshot.StateSetDataPointSnapshot dataPoint, int i, long currentTimeMillis) {
        return new DoublePointDataImpl(dataPoint.isTrue(i) ? 1.0 : 0.0, this.getStartEpochNanos((DataPointSnapshot)dataPoint), this.getEpochNanos((DataPointSnapshot)dataPoint, currentTimeMillis), this.labelsToAttributes(dataPoint.getLabels().merge(Labels.of((String[])new String[]{snapshot.getMetadata().getName(), dataPoint.getName(i)}))), Collections.emptyList());
    }
}

