/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry.otelmodel;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.SummaryPointData;
import io.opentelemetry.sdk.metrics.data.ValueAtQuantile;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PointDataImpl;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.ValueAtQuantileImpl;
import java.util.ArrayList;
import java.util.List;

public class SummaryPointDataImpl
extends PointDataImpl
implements SummaryPointData {
    private final double sum;
    private final long count;
    private final List<ValueAtQuantile> values;

    public SummaryPointDataImpl(double sum, long count, long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars) {
        super(startEpochNanos, epochNanos, attributes, exemplars);
        this.sum = sum;
        this.count = count;
        this.values = new ArrayList<ValueAtQuantile>();
    }

    void addValue(double quantile, double value) {
        this.values.add(new ValueAtQuantileImpl(quantile, value));
    }

    public long getCount() {
        return this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public List<ValueAtQuantile> getValues() {
        return this.values;
    }
}

