/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry;

import io.prometheus.metrics.exporter.opentelemetry.ResourceAttributesDefaults;
import io.prometheus.metrics.exporter.opentelemetry.ResourceAttributesFromJarFileName;
import io.prometheus.metrics.exporter.opentelemetry.ResourceAttributesFromOtelAgent;
import java.util.HashMap;
import java.util.Map;

public class ResourceAttributes {
    public static Map<String, String> get(String instrumentationScopeName, String serviceName, String serviceNamespace, String serviceInstanceId, String serviceVersion, Map<String, String> configuredResourceAttributes) {
        HashMap<String, String> result = new HashMap<String, String>();
        ResourceAttributesFromOtelAgent.addIfAbsent(result, instrumentationScopeName);
        ResourceAttributes.putIfAbsent(result, "service.name", serviceName);
        ResourceAttributes.putIfAbsent(result, "service.namespace", serviceNamespace);
        ResourceAttributes.putIfAbsent(result, "service.instance.id", serviceInstanceId);
        ResourceAttributes.putIfAbsent(result, "service.version", serviceVersion);
        for (Map.Entry<String, String> attribute : configuredResourceAttributes.entrySet()) {
            ResourceAttributes.putIfAbsent(result, attribute.getKey(), attribute.getValue());
        }
        ResourceAttributesFromJarFileName.addIfAbsent(result);
        ResourceAttributesDefaults.addIfAbsent(result);
        return result;
    }

    private static void putIfAbsent(Map<String, String> result, String key, String value) {
        if (value != null) {
            result.putIfAbsent(key, value);
        }
    }
}

