/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class ResourceAttributesFromJarFileName {
    public static void addIfAbsent(Map<String, String> result) {
        if (result.containsKey("service.name")) {
            return;
        }
        Path jarPath = ResourceAttributesFromJarFileName.getJarPathFromSunCommandLine();
        if (jarPath == null) {
            return;
        }
        String serviceName = ResourceAttributesFromJarFileName.getServiceName(jarPath);
        result.putIfAbsent("service.name", serviceName);
    }

    private static Path getJarPathFromSunCommandLine() {
        Path path;
        String programArguments = System.getProperty("sun.java.command");
        if (programArguments == null) {
            return null;
        }
        int next = 0;
        do {
            int nextSpace;
            if ((nextSpace = programArguments.indexOf(32, next)) == -1) {
                return ResourceAttributesFromJarFileName.pathIfExists(programArguments);
            }
            path = ResourceAttributesFromJarFileName.pathIfExists(programArguments.substring(0, nextSpace));
            next = nextSpace + 1;
        } while (path == null);
        return path;
    }

    private static Path pathIfExists(String programArguments) {
        Path candidate;
        try {
            candidate = Paths.get(programArguments, new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
        return Files.isRegularFile(candidate, new LinkOption[0]) ? candidate : null;
    }

    private static String getServiceName(Path jarPath) {
        String jarName = jarPath.getFileName().toString();
        int dotIndex = jarName.lastIndexOf(".");
        return dotIndex == -1 ? jarName : jarName.substring(0, dotIndex);
    }
}

