/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry;

import io.prometheus.metrics.config.PrometheusProperties;
import io.prometheus.metrics.exporter.opentelemetry.OtelAutoConfig;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.export.MetricReader;
import java.util.HashMap;
import java.util.Map;

public class OpenTelemetryExporter
implements AutoCloseable {
    private final MetricReader reader;

    public OpenTelemetryExporter(MetricReader reader) {
        this.reader = reader;
    }

    @Override
    public void close() {
        this.reader.shutdown();
    }

    public static Builder builder() {
        return new Builder(PrometheusProperties.get());
    }

    public static Builder builder(PrometheusProperties config) {
        return new Builder(config);
    }

    public static class Builder {
        private final PrometheusProperties config;
        private PrometheusRegistry registry = null;
        String protocol;
        String endpoint;
        final Map<String, String> headers = new HashMap<String, String>();
        String interval;
        String timeout;
        String serviceName;
        String serviceNamespace;
        String serviceInstanceId;
        String serviceVersion;
        final Map<String, String> resourceAttributes = new HashMap<String, String>();

        private Builder(PrometheusProperties config) {
            this.config = config;
        }

        public Builder registry(PrometheusRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder protocol(String protocol) {
            if (!protocol.equals("grpc") && !protocol.equals("http/protobuf")) {
                throw new IllegalArgumentException(protocol + ": Unsupported protocol. Expecting grpc or http/protobuf");
            }
            this.protocol = protocol;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder intervalSeconds(int intervalSeconds) {
            if (intervalSeconds <= 0) {
                throw new IllegalStateException(intervalSeconds + ": expecting a push interval > 0s");
            }
            this.interval = intervalSeconds + "s";
            return this;
        }

        public Builder timeoutSeconds(int timeoutSeconds) {
            if (timeoutSeconds <= 0) {
                throw new IllegalStateException(timeoutSeconds + ": expecting a push interval > 0s");
            }
            this.timeout = timeoutSeconds + "s";
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        public Builder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public Builder serviceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public Builder resourceAttribute(String name, String value) {
            this.resourceAttributes.put(name, value);
            return this;
        }

        public OpenTelemetryExporter buildAndStart() {
            if (this.registry == null) {
                this.registry = PrometheusRegistry.defaultRegistry;
            }
            return new OpenTelemetryExporter(OtelAutoConfig.createReader(this, this.config, this.registry));
        }
    }
}

