/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry.otelmodel;

import io.prometheus.metrics.exporter.opentelemetry.otelmodel.HistogramPointDataImpl;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusData;
import io.prometheus.metrics.model.snapshots.ClassicHistogramBuckets;
import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.model.snapshots.HistogramSnapshot;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.data.AggregationTemporality;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.data.HistogramData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.data.HistogramPointData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.data.MetricDataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class PrometheusClassicHistogram
extends PrometheusData<HistogramPointData>
implements HistogramData {
    private final List<HistogramPointData> points;

    PrometheusClassicHistogram(HistogramSnapshot snapshot, long currentTimeMillis) {
        super(MetricDataType.HISTOGRAM);
        this.points = snapshot.getDataPoints().stream().map(dataPoint -> this.toOtelDataPoint((HistogramSnapshot.HistogramDataPointSnapshot)dataPoint, currentTimeMillis)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public AggregationTemporality getAggregationTemporality() {
        return AggregationTemporality.CUMULATIVE;
    }

    @Override
    public Collection<HistogramPointData> getPoints() {
        return this.points;
    }

    private HistogramPointData toOtelDataPoint(HistogramSnapshot.HistogramDataPointSnapshot dataPoint, long currentTimeMillis) {
        if (!dataPoint.hasClassicHistogramData()) {
            return null;
        }
        return new HistogramPointDataImpl(dataPoint.hasSum() ? dataPoint.getSum() : Double.NaN, dataPoint.hasCount() ? dataPoint.getCount() : this.calculateCount(dataPoint.getClassicBuckets()), Double.NaN, Double.NaN, this.makeBoundaries(dataPoint.getClassicBuckets()), this.makeCounts(dataPoint.getClassicBuckets()), this.getStartEpochNanos((DataPointSnapshot)dataPoint), this.getEpochNanos((DataPointSnapshot)dataPoint, currentTimeMillis), this.labelsToAttributes(dataPoint.getLabels()), this.convertExemplars(dataPoint.getExemplars()));
    }

    private long calculateCount(ClassicHistogramBuckets buckets) {
        long result = 0L;
        for (int i = 0; i < buckets.size(); ++i) {
            result += buckets.getCount(i);
        }
        return result;
    }

    private List<Double> makeBoundaries(ClassicHistogramBuckets buckets) {
        ArrayList<Double> result = new ArrayList<Double>(buckets.size());
        for (int i = 0; i < buckets.size(); ++i) {
            result.add(buckets.getUpperBound(i));
        }
        return result;
    }

    private List<Long> makeCounts(ClassicHistogramBuckets buckets) {
        ArrayList<Long> result = new ArrayList<Long>(buckets.size());
        for (int i = 0; i < buckets.size(); ++i) {
            result.add(buckets.getCount(i));
        }
        return result;
    }
}

