/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.trace;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.internal.ApiUsageLogger;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.internal.OtelEncodingUtils;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.internal.TemporaryBuffers;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TraceId {
    private static final int BYTES_LENGTH = 16;
    private static final int HEX_LENGTH = 32;
    private static final String INVALID = "00000000000000000000000000000000";

    private TraceId() {
    }

    public static int getLength() {
        return 32;
    }

    public static String getInvalid() {
        return INVALID;
    }

    public static boolean isValid(CharSequence traceId) {
        return traceId != null && traceId.length() == 32 && !INVALID.contentEquals(traceId) && OtelEncodingUtils.isValidBase16String(traceId);
    }

    public static String fromBytes(byte[] traceIdBytes) {
        if (traceIdBytes == null || traceIdBytes.length < 16) {
            ApiUsageLogger.log("traceIdBytes is null or too short");
            return INVALID;
        }
        char[] result = TemporaryBuffers.chars(32);
        OtelEncodingUtils.bytesToBase16(traceIdBytes, result, 16);
        return new String(result, 0, 32);
    }

    public static String fromLongs(long traceIdLongHighPart, long traceIdLongLowPart) {
        if (traceIdLongHighPart == 0L && traceIdLongLowPart == 0L) {
            return TraceId.getInvalid();
        }
        char[] chars = TemporaryBuffers.chars(32);
        OtelEncodingUtils.longToBase16String(traceIdLongHighPart, chars, 0);
        OtelEncodingUtils.longToBase16String(traceIdLongLowPart, chars, 16);
        return new String(chars, 0, 32);
    }
}

