/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context.ContextKey;
import java.util.Arrays;
import javax.annotation.Nullable;

final class ArrayBasedContext
implements Context {
    private static final Context ROOT = new ArrayBasedContext(new Object[0]);
    private final Object[] entries;

    static Context root() {
        return ROOT;
    }

    private ArrayBasedContext(Object[] entries) {
        this.entries = entries;
    }

    @Override
    @Nullable
    public <V> V get(ContextKey<V> key) {
        for (int i = 0; i < this.entries.length; i += 2) {
            if (this.entries[i] != key) continue;
            Object result = this.entries[i + 1];
            return (V)result;
        }
        return null;
    }

    @Override
    public <V> Context with(ContextKey<V> key, V value) {
        for (int i = 0; i < this.entries.length; i += 2) {
            if (this.entries[i] != key) continue;
            if (this.entries[i + 1] == value) {
                return this;
            }
            Object[] newEntries = (Object[])this.entries.clone();
            newEntries[i + 1] = value;
            return new ArrayBasedContext(newEntries);
        }
        Object[] newEntries = Arrays.copyOf(this.entries, this.entries.length + 2);
        newEntries[newEntries.length - 2] = key;
        newEntries[newEntries.length - 1] = value;
        return new ArrayBasedContext(newEntries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < this.entries.length; i += 2) {
            sb.append(this.entries[i]).append('=').append(this.entries[i + 1]).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }
}

