/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.grpc;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.CodedInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class GrpcExporterUtil {
    public static final int GRPC_STATUS_CANCELLED = 1;
    public static final int GRPC_STATUS_UNKNOWN = 2;
    public static final int GRPC_STATUS_DEADLINE_EXCEEDED = 4;
    public static final int GRPC_STATUS_RESOURCE_EXHAUSTED = 8;
    public static final int GRPC_STATUS_ABORTED = 10;
    public static final int GRPC_STATUS_OUT_OF_RANGE = 11;
    public static final int GRPC_STATUS_UNIMPLEMENTED = 12;
    public static final int GRPC_STATUS_UNAVAILABLE = 14;
    public static final int GRPC_STATUS_DATA_LOSS = 15;

    static void logUnimplemented(Logger logger, String type, @Nullable String fullErrorMessage) {
        String envVar;
        switch (type) {
            case "span": {
                envVar = "OTEL_TRACES_EXPORTER";
                break;
            }
            case "metric": {
                envVar = "OTEL_METRICS_EXPORTER";
                break;
            }
            case "log": {
                envVar = "OTEL_LOGS_EXPORTER";
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized type, this is a programming bug in the OpenTelemetry SDK");
            }
        }
        logger.log(Level.SEVERE, "Failed to export " + type + "s. Server responded with UNIMPLEMENTED. This usually means that your collector is not configured with an otlp receiver in the \"pipelines\" section of the configuration. If export is not desired and you are using OpenTelemetry autoconfiguration or the javaagent, disable export by setting " + envVar + "=none. Full error message: " + fullErrorMessage);
    }

    private GrpcExporterUtil() {
    }

    public static String getStatusMessage(byte[] serializedStatus) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance(serializedStatus);
        boolean done = false;
        block4: while (!done) {
            int tag = input.readTag();
            switch (tag) {
                case 0: {
                    done = true;
                    continue block4;
                }
                case 18: {
                    return input.readStringRequireUtf8();
                }
            }
            input.skipField(tag);
        }
        return "";
    }
}

