/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.http;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.metrics.MeterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.ExporterMetrics;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.FailedExportException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.grpc.GrpcExporterUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.http.HttpSender;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.internal.ThrottlingLogger;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class HttpExporter<T extends Marshaler> {
    private static final Logger internalLogger = Logger.getLogger(HttpExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final String type;
    private final HttpSender httpSender;
    private final ExporterMetrics exporterMetrics;

    public HttpExporter(String exporterName, String type, HttpSender httpSender, Supplier<MeterProvider> meterProviderSupplier, boolean exportAsJson) {
        this.type = type;
        this.httpSender = httpSender;
        this.exporterMetrics = exportAsJson ? ExporterMetrics.createHttpJson(exporterName, type, meterProviderSupplier) : ExporterMetrics.createHttpProtobuf(exporterName, type, meterProviderSupplier);
    }

    public CompletableResultCode export(T exportRequest, int numItems) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        this.exporterMetrics.addSeen(numItems);
        CompletableResultCode result = new CompletableResultCode();
        this.httpSender.send((Marshaler)exportRequest, ((Marshaler)exportRequest).getBinarySerializedSize(), httpResponse -> this.onResponse(result, numItems, (HttpSender.Response)httpResponse), throwable -> this.onError(result, numItems, (Throwable)throwable));
        return result;
    }

    private void onResponse(CompletableResultCode result, int numItems, HttpSender.Response httpResponse) {
        int statusCode = httpResponse.statusCode();
        if (statusCode >= 200 && statusCode < 300) {
            this.exporterMetrics.addSuccess(numItems);
            result.succeed();
            return;
        }
        this.exporterMetrics.addFailed(numItems);
        byte[] body = null;
        try {
            body = httpResponse.responseBody();
        }
        catch (IOException ex) {
            this.logger.log(Level.FINE, "Unable to obtain response body", ex);
        }
        String status = HttpExporter.extractErrorStatus(httpResponse.statusMessage(), body);
        this.logger.log(Level.WARNING, "Failed to export " + this.type + "s. Server responded with HTTP status code " + statusCode + ". Error message: " + status);
        result.failExceptionally(FailedExportException.httpFailedWithResponse(httpResponse));
    }

    private void onError(CompletableResultCode result, int numItems, Throwable e) {
        this.exporterMetrics.addFailed(numItems);
        this.logger.log(Level.SEVERE, "Failed to export " + this.type + "s. The request could not be executed. Full error message: " + e.getMessage(), e);
        result.failExceptionally(FailedExportException.httpFailedExceptionally(e));
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.httpSender.shutdown();
    }

    private static String extractErrorStatus(String statusMessage, @Nullable byte[] responseBody) {
        if (responseBody == null) {
            return "Response body missing, HTTP status message: " + statusMessage;
        }
        try {
            return GrpcExporterUtil.getStatusMessage(responseBody);
        }
        catch (IOException e) {
            return "Unable to parse response body, HTTP status message: " + statusMessage;
        }
    }
}

