/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.internal.OtelEncodingUtils;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.trace.SpanId;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.trace.TraceId;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.CodedOutputStream;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.MarshalerContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.ProtoEnumInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.ProtoFieldInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.StatelessMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.StatelessMarshalerUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ProtoSerializer
extends Serializer
implements AutoCloseable {
    private static final ThreadLocal<Map<String, byte[]>> THREAD_LOCAL_ID_CACHE = new ThreadLocal();
    private final CodedOutputStream output;
    private final Map<String, byte[]> idCache;

    ProtoSerializer(OutputStream output) {
        this.output = CodedOutputStream.newInstance(output);
        this.idCache = ProtoSerializer.getIdCache();
    }

    @Override
    protected void writeTraceId(ProtoFieldInfo field, String traceId) throws IOException {
        byte[] traceIdBytes = this.idCache.computeIfAbsent(traceId, id -> OtelEncodingUtils.bytesFromBase16(id, TraceId.getLength()));
        this.writeBytes(field, traceIdBytes);
    }

    @Override
    protected void writeTraceId(ProtoFieldInfo field, String traceId, MarshalerContext context) throws IOException {
        byte[] traceIdBytes = this.idCache.get(traceId);
        if (traceIdBytes == null) {
            traceIdBytes = context.getTraceIdBuffer();
            OtelEncodingUtils.bytesFromBase16(traceId, TraceId.getLength(), traceIdBytes);
            this.idCache.put(traceId, traceIdBytes);
        }
        this.writeBytes(field, traceIdBytes);
    }

    @Override
    protected void writeSpanId(ProtoFieldInfo field, String spanId) throws IOException {
        byte[] spanIdBytes = this.idCache.computeIfAbsent(spanId, id -> OtelEncodingUtils.bytesFromBase16(id, SpanId.getLength()));
        this.writeBytes(field, spanIdBytes);
    }

    @Override
    protected void writeSpanId(ProtoFieldInfo field, String spanId, MarshalerContext context) throws IOException {
        byte[] spanIdBytes = this.idCache.get(spanId);
        if (spanIdBytes == null) {
            spanIdBytes = context.getSpanIdBuffer();
            OtelEncodingUtils.bytesFromBase16(spanId, SpanId.getLength(), spanIdBytes);
            this.idCache.put(spanId, spanIdBytes);
        }
        this.writeBytes(field, spanIdBytes);
    }

    @Override
    public void writeBool(ProtoFieldInfo field, boolean value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeBoolNoTag(value);
    }

    @Override
    protected void writeEnum(ProtoFieldInfo field, ProtoEnumInfo enumValue) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeEnumNoTag(enumValue.getEnumNumber());
    }

    @Override
    protected void writeUint32(ProtoFieldInfo field, int value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeUInt32NoTag(value);
    }

    @Override
    protected void writeSInt32(ProtoFieldInfo field, int value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeSInt32NoTag(value);
    }

    @Override
    protected void writeint32(ProtoFieldInfo field, int value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeInt32NoTag(value);
    }

    @Override
    public void writeInt64(ProtoFieldInfo field, long value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeInt64NoTag(value);
    }

    @Override
    public void writeUInt64(ProtoFieldInfo field, long value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeUInt64NoTag(value);
    }

    @Override
    protected void writeFixed64(ProtoFieldInfo field, long value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeFixed64NoTag(value);
    }

    @Override
    protected void writeFixed64Value(long value) throws IOException {
        this.output.writeFixed64NoTag(value);
    }

    @Override
    protected void writeUInt64Value(long value) throws IOException {
        this.output.writeUInt64NoTag(value);
    }

    @Override
    protected void writeFixed32(ProtoFieldInfo field, int value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeFixed32NoTag(value);
    }

    @Override
    public void writeDouble(ProtoFieldInfo field, double value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeDoubleNoTag(value);
    }

    @Override
    protected void writeDoubleValue(double value) throws IOException {
        this.output.writeDoubleNoTag(value);
    }

    @Override
    public void writeString(ProtoFieldInfo field, byte[] utf8Bytes) throws IOException {
        this.writeBytes(field, utf8Bytes);
    }

    @Override
    public void writeString(ProtoFieldInfo field, String string, int utf8Length, MarshalerContext context) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeUInt32NoTag(utf8Length);
        StatelessMarshalerUtil.writeUtf8(this.output, string, utf8Length, context);
    }

    @Override
    public void writeBytes(ProtoFieldInfo field, byte[] value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeByteArrayNoTag(value);
    }

    @Override
    public void writeByteBuffer(ProtoFieldInfo field, ByteBuffer value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeByteBufferNoTag(value);
    }

    @Override
    protected void writeStartMessage(ProtoFieldInfo field, int protoMessageSize) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeUInt32NoTag(protoMessageSize);
    }

    @Override
    protected void writeEndMessage() {
    }

    @Override
    protected void writeStartRepeatedPrimitive(ProtoFieldInfo field, int protoSizePerElement, int numElements) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeUInt32NoTag(protoSizePerElement * numElements);
    }

    @Override
    protected void writeEndRepeatedPrimitive() {
    }

    @Override
    protected void writeStartRepeatedVarint(ProtoFieldInfo field, int payloadSize) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeUInt32NoTag(payloadSize);
    }

    @Override
    protected void writeEndRepeatedVarint() {
    }

    @Override
    public void serializeRepeatedMessage(ProtoFieldInfo field, Marshaler[] repeatedMessage) throws IOException {
        for (Marshaler message : repeatedMessage) {
            this.serializeMessage(field, message);
        }
    }

    @Override
    public void serializeRepeatedMessage(ProtoFieldInfo field, List<? extends Marshaler> repeatedMessage) throws IOException {
        for (Marshaler marshaler : repeatedMessage) {
            this.serializeMessage(field, marshaler);
        }
    }

    @Override
    public <T> void serializeRepeatedMessageWithContext(ProtoFieldInfo field, List<? extends T> messages, StatelessMarshaler<T> marshaler, MarshalerContext context) throws IOException {
        for (int i = 0; i < messages.size(); ++i) {
            T message = messages.get(i);
            this.writeStartMessage(field, context.getSize());
            marshaler.writeTo(this, message, context);
            this.writeEndMessage();
        }
    }

    @Override
    protected void writeStartRepeated(ProtoFieldInfo field) {
    }

    @Override
    protected void writeEndRepeated() {
    }

    @Override
    protected void writeStartRepeatedElement(ProtoFieldInfo field, int protoMessageSize) throws IOException {
        this.writeStartMessage(field, protoMessageSize);
    }

    @Override
    protected void writeEndRepeatedElement() {
        this.writeEndMessage();
    }

    @Override
    public void writeSerializedMessage(byte[] protoSerialized, String jsonSerialized) throws IOException {
        this.output.writeRawBytes(protoSerialized);
    }

    @Override
    public void close() throws IOException {
        try {
            this.output.flush();
            this.idCache.clear();
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    private static Map<String, byte[]> getIdCache() {
        Map<String, byte[]> result = THREAD_LOCAL_ID_CACHE.get();
        if (result == null) {
            result = new HashMap<String, byte[]>();
            THREAD_LOCAL_ID_CACHE.set(result);
        }
        return result;
    }
}

