/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.otlp.logs;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.otlp.logs.LogsRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.otlp.logs.LowAllocationLogsRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.logs.data.LogRecordData;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.function.BiFunction;

public class LogReusableDataMarshaler {
    private final Deque<LowAllocationLogsRequestMarshaler> marshalerPool = new ArrayDeque<LowAllocationLogsRequestMarshaler>();
    private final MemoryMode memoryMode;
    private final BiFunction<Marshaler, Integer, CompletableResultCode> doExport;

    public LogReusableDataMarshaler(MemoryMode memoryMode, BiFunction<Marshaler, Integer, CompletableResultCode> doExport) {
        this.memoryMode = memoryMode;
        this.doExport = doExport;
    }

    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    public CompletableResultCode export(Collection<LogRecordData> logs) {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            LowAllocationLogsRequestMarshaler marshaler = this.marshalerPool.poll();
            if (marshaler == null) {
                marshaler = new LowAllocationLogsRequestMarshaler();
            }
            LowAllocationLogsRequestMarshaler exportMarshaler = marshaler;
            exportMarshaler.initialize(logs);
            return this.doExport.apply(exportMarshaler, logs.size()).whenComplete(() -> {
                exportMarshaler.reset();
                this.marshalerPool.add(exportMarshaler);
            });
        }
        LogsRequestMarshaler request = LogsRequestMarshaler.create(logs);
        return this.doExport.apply(request, logs.size());
    }
}

