/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.otlp.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.ProtoFieldInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.otlp.KeyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.otlp.metrics.ExemplarMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.proto.metrics.v1.internal.NumberDataPoint;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.data.DoublePointData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.data.LongPointData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.data.PointData;
import java.io.IOException;
import java.util.Collection;

final class NumberDataPointMarshaler
extends MarshalerWithSize {
    private final long startTimeUnixNano;
    private final long timeUnixNano;
    private final PointData value;
    private final ProtoFieldInfo valueField;
    private final ExemplarMarshaler[] exemplars;
    private final KeyValueMarshaler[] attributes;

    static NumberDataPointMarshaler[] createRepeated(Collection<? extends PointData> points) {
        int numPoints = points.size();
        NumberDataPointMarshaler[] marshalers = new NumberDataPointMarshaler[numPoints];
        int index = 0;
        for (PointData pointData : points) {
            marshalers[index++] = NumberDataPointMarshaler.create(pointData);
        }
        return marshalers;
    }

    static NumberDataPointMarshaler create(PointData point) {
        ExemplarMarshaler[] exemplarMarshalers = ExemplarMarshaler.createRepeated(point.getExemplars());
        KeyValueMarshaler[] attributeMarshalers = KeyValueMarshaler.createForAttributes(point.getAttributes());
        return new NumberDataPointMarshaler(point.getStartEpochNanos(), point.getEpochNanos(), point, NumberDataPointMarshaler.toProtoPointValueType(point), exemplarMarshalers, attributeMarshalers);
    }

    private NumberDataPointMarshaler(long startTimeUnixNano, long timeUnixNano, PointData value, ProtoFieldInfo valueField, ExemplarMarshaler[] exemplars, KeyValueMarshaler[] attributes) {
        super(NumberDataPointMarshaler.calculateSize(startTimeUnixNano, timeUnixNano, valueField, value, exemplars, attributes));
        this.startTimeUnixNano = startTimeUnixNano;
        this.timeUnixNano = timeUnixNano;
        this.value = value;
        this.valueField = valueField;
        this.exemplars = exemplars;
        this.attributes = attributes;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeFixed64(NumberDataPoint.START_TIME_UNIX_NANO, this.startTimeUnixNano);
        output.serializeFixed64(NumberDataPoint.TIME_UNIX_NANO, this.timeUnixNano);
        if (this.valueField == NumberDataPoint.AS_INT) {
            output.serializeFixed64Optional(this.valueField, ((LongPointData)this.value).getValue());
        } else {
            output.serializeDoubleOptional(this.valueField, ((DoublePointData)this.value).getValue());
        }
        output.serializeRepeatedMessage(NumberDataPoint.EXEMPLARS, this.exemplars);
        output.serializeRepeatedMessage(NumberDataPoint.ATTRIBUTES, this.attributes);
    }

    private static int calculateSize(long startTimeUnixNano, long timeUnixNano, ProtoFieldInfo valueField, PointData value, ExemplarMarshaler[] exemplars, KeyValueMarshaler[] attributes) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64(NumberDataPoint.START_TIME_UNIX_NANO, startTimeUnixNano);
        size += MarshalerUtil.sizeFixed64(NumberDataPoint.TIME_UNIX_NANO, timeUnixNano);
        size = valueField == NumberDataPoint.AS_INT ? (size += MarshalerUtil.sizeFixed64Optional(valueField, ((LongPointData)value).getValue())) : (size += MarshalerUtil.sizeDoubleOptional(valueField, ((DoublePointData)value).getValue()));
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)NumberDataPoint.EXEMPLARS, (Marshaler[])exemplars);
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)NumberDataPoint.ATTRIBUTES, (Marshaler[])attributes);
    }

    static ProtoFieldInfo toProtoPointValueType(PointData pointData) {
        if (pointData instanceof LongPointData) {
            return NumberDataPoint.AS_INT;
        }
        assert (pointData instanceof DoublePointData);
        return NumberDataPoint.AS_DOUBLE;
    }
}

