/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.otlp.traces;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.MarshalerContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.StatelessMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.StatelessMarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.otlp.AttributeKeyValueStatelessMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.otlp.traces.SpanFlags;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.otlp.traces.SpanLinkMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.proto.trace.v1.internal.Span;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.trace.data.LinkData;
import java.io.IOException;

final class SpanLinkStatelessMarshaler
implements StatelessMarshaler<LinkData> {
    static final SpanLinkStatelessMarshaler INSTANCE = new SpanLinkStatelessMarshaler();

    private SpanLinkStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, LinkData link, MarshalerContext context) throws IOException {
        output.serializeTraceId(Span.Link.TRACE_ID, link.getSpanContext().getTraceId(), context);
        output.serializeSpanId(Span.Link.SPAN_ID, link.getSpanContext().getSpanId(), context);
        output.serializeString(Span.Link.TRACE_STATE, context.getData(byte[].class));
        output.serializeRepeatedMessageWithContext(Span.Link.ATTRIBUTES, link.getAttributes(), AttributeKeyValueStatelessMarshaler.INSTANCE, context);
        int droppedAttributesCount = link.getTotalAttributeCount() - link.getAttributes().size();
        output.serializeUInt32(Span.Link.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
        output.serializeFixed32(Span.Link.FLAGS, SpanFlags.withParentIsRemoteFlags(link.getSpanContext().getTraceFlags(), link.getSpanContext().isRemote()));
    }

    @Override
    public int getBinarySerializedSize(LinkData link, MarshalerContext context) {
        byte[] traceStateUtf8 = SpanLinkMarshaler.encodeSpanLinkTraceState(link);
        context.addData(traceStateUtf8);
        int size = 0;
        size += MarshalerUtil.sizeTraceId(Span.Link.TRACE_ID, link.getSpanContext().getTraceId());
        size += MarshalerUtil.sizeSpanId(Span.Link.SPAN_ID, link.getSpanContext().getSpanId());
        size += MarshalerUtil.sizeBytes(Span.Link.TRACE_STATE, traceStateUtf8);
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext(Span.Link.ATTRIBUTES, link.getAttributes(), AttributeKeyValueStatelessMarshaler.INSTANCE, context);
        int droppedAttributesCount = link.getTotalAttributeCount() - link.getAttributes().size();
        size += MarshalerUtil.sizeUInt32(Span.Link.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
        return size += MarshalerUtil.sizeFixed32(Span.Link.FLAGS, SpanFlags.withParentIsRemoteFlags(link.getSpanContext().getTraceFlags(), link.getSpanContext().isRemote()));
    }
}

