/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.otlp.http.logs;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.http.HttpExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.http.HttpExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.otlp.logs.LogReusableDataMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.logs.data.LogRecordData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.logs.export.LogRecordExporter;
import java.util.Collection;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpLogRecordExporter
implements LogRecordExporter {
    private final HttpExporterBuilder<Marshaler> builder;
    private final HttpExporter<Marshaler> delegate;
    private final LogReusableDataMarshaler marshaler;

    OtlpHttpLogRecordExporter(HttpExporterBuilder<Marshaler> builder, HttpExporter<Marshaler> delegate, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.marshaler = new LogReusableDataMarshaler(memoryMode, delegate::export);
    }

    public static OtlpHttpLogRecordExporter getDefault() {
        return OtlpHttpLogRecordExporter.builder().build();
    }

    public static OtlpHttpLogRecordExporterBuilder builder() {
        return new OtlpHttpLogRecordExporterBuilder();
    }

    public OtlpHttpLogRecordExporterBuilder toBuilder() {
        return new OtlpHttpLogRecordExporterBuilder(this.builder.copy(), this.marshaler.getMemoryMode());
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> logs) {
        return this.marshaler.export(logs);
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpHttpLogRecordExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("memoryMode=" + (Object)((Object)this.marshaler.getMemoryMode()));
        return joiner.toString();
    }
}

