/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.otlp.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.otlp.internal.OtlpConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.internal.StructuredConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.logs.export.LogRecordExporter;

public class OtlpLogRecordExporterComponentProvider
implements ComponentProvider<LogRecordExporter> {
    @Override
    public Class<LogRecordExporter> getType() {
        return LogRecordExporter.class;
    }

    @Override
    public String getName() {
        return "otlp";
    }

    @Override
    public LogRecordExporter create(StructuredConfigProperties config) {
        String protocol = OtlpConfigUtil.getStructuredConfigOtlpProtocol(config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpLogRecordExporterBuilder builder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("logs", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcLogRecordExporterBuilder builder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("logs", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
    }

    OtlpHttpLogRecordExporterBuilder httpBuilder() {
        return OtlpHttpLogRecordExporter.builder();
    }

    OtlpGrpcLogRecordExporterBuilder grpcBuilder() {
        return OtlpGrpcLogRecordExporter.builder();
    }
}

