/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.sender.okhttp.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.internal.InstrumentationUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.RetryUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.compression.Compressor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.grpc.GrpcResponse;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.grpc.GrpcSender;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.sender.okhttp.internal.GrpcRequestBody;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.sender.okhttp.internal.OkHttpUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.exporter.sender.okhttp.internal.RetryInterceptor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okhttp3.Call;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okhttp3.Callback;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okhttp3.ConnectionSpec;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okhttp3.HttpUrl;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okhttp3.OkHttpClient;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okhttp3.Protocol;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okhttp3.Request;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okhttp3.Response;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.common.export.RetryPolicy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OkHttpGrpcSender<T extends Marshaler>
implements GrpcSender<T> {
    private static final String GRPC_STATUS = "grpc-status";
    private static final String GRPC_MESSAGE = "grpc-message";
    private final OkHttpClient client;
    private final HttpUrl url;
    private final Supplier<Map<String, List<String>>> headersSupplier;
    @Nullable
    private final Compressor compressor;

    public OkHttpGrpcSender(String endpoint, @Nullable Compressor compressor, long timeoutNanos, long connectTimeoutNanos, Supplier<Map<String, List<String>>> headersSupplier, @Nullable RetryPolicy retryPolicy, @Nullable SSLContext sslContext, @Nullable X509TrustManager trustManager) {
        boolean isPlainHttp;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().dispatcher(OkHttpUtil.newDispatcher()).callTimeout(Duration.ofNanos(timeoutNanos)).connectTimeout(Duration.ofNanos(connectTimeoutNanos));
        if (retryPolicy != null) {
            clientBuilder.addInterceptor(new RetryInterceptor(retryPolicy, OkHttpGrpcSender::isRetryable));
        }
        if (isPlainHttp = endpoint.startsWith("http://")) {
            clientBuilder.connectionSpecs(Collections.singletonList(ConnectionSpec.CLEARTEXT));
            clientBuilder.protocols(Collections.singletonList(Protocol.H2_PRIOR_KNOWLEDGE));
        } else {
            clientBuilder.protocols(Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1));
            if (sslContext != null && trustManager != null) {
                clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
            }
        }
        this.client = clientBuilder.build();
        this.headersSupplier = headersSupplier;
        this.url = HttpUrl.get(endpoint);
        this.compressor = compressor;
    }

    @Override
    public void send(T request, final Consumer<GrpcResponse> onResponse, final Consumer<Throwable> onError) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url);
        Map<String, List<String>> headers = this.headersSupplier.get();
        if (headers != null) {
            headers.forEach((key, values2) -> values2.forEach(value -> requestBuilder.addHeader((String)key, (String)value)));
        }
        requestBuilder.addHeader("te", "trailers");
        if (this.compressor != null) {
            requestBuilder.addHeader("grpc-encoding", this.compressor.getEncoding());
        }
        GrpcRequestBody requestBody = new GrpcRequestBody((Marshaler)request, this.compressor);
        requestBuilder.post(requestBody);
        InstrumentationUtil.suppressInstrumentation(() -> this.client.newCall(requestBuilder.build()).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                onError.accept(e);
            }

            @Override
            public void onResponse(Call call, Response response) {
                int statusCode;
                try {
                    response.body().bytes();
                }
                catch (IOException e) {
                    onError.accept(new RuntimeException("Could not consume server response", e));
                    return;
                }
                String status = OkHttpGrpcSender.grpcStatus(response);
                String description = OkHttpGrpcSender.grpcMessage(response);
                try {
                    statusCode = Integer.parseInt(status);
                }
                catch (NumberFormatException ex) {
                    statusCode = 2;
                }
                onResponse.accept(GrpcResponse.create(statusCode, description));
            }
        }));
    }

    @Nullable
    private static String grpcStatus(Response response) {
        String grpcStatus = response.header(GRPC_STATUS);
        if (grpcStatus == null) {
            try {
                grpcStatus = response.trailers().get(GRPC_STATUS);
            }
            catch (IOException e) {
                return null;
            }
        }
        return grpcStatus;
    }

    private static String grpcMessage(Response response) {
        String message = response.header(GRPC_MESSAGE);
        if (message == null) {
            try {
                message = response.trailers().get(GRPC_MESSAGE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (message != null) {
            return OkHttpGrpcSender.unescape(message);
        }
        return response.message();
    }

    @Override
    public CompletableResultCode shutdown() {
        this.client.dispatcher().cancelAll();
        this.client.dispatcher().executorService().shutdownNow();
        this.client.connectionPool().evictAll();
        return CompletableResultCode.ofSuccess();
    }

    public static boolean isRetryable(Response response) {
        String grpcStatus = response.header(GRPC_STATUS);
        if (grpcStatus == null) {
            return false;
        }
        return RetryUtil.retryableGrpcStatusCodes().contains(grpcStatus);
    }

    private static String unescape(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '~' && (c != '%' || i + 2 >= value.length())) continue;
            return OkHttpGrpcSender.doUnescape(value.getBytes(StandardCharsets.US_ASCII));
        }
        return value;
    }

    private static String doUnescape(byte[] value) {
        ByteBuffer buf = ByteBuffer.allocate(value.length);
        int i = 0;
        while (i < value.length) {
            if (value[i] == 37 && i + 2 < value.length) {
                try {
                    buf.put((byte)Integer.parseInt(new String(value, i + 1, 2, StandardCharsets.UTF_8), 16));
                    i += 3;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            buf.put(value[i]);
            ++i;
        }
        return new String(buf.array(), 0, buf.position(), StandardCharsets.UTF_8);
    }
}

