/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.incubator.semconv.code;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.AttributesBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.incubator.semconv.code.CodeAttributesGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.instrumenter.AttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.internal.AttributesExtractorUtil;
import javax.annotation.Nullable;

public final class CodeAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private static final AttributeKey<String> CODE_FUNCTION = AttributeKey.stringKey("code.function");
    private static final AttributeKey<String> CODE_NAMESPACE = AttributeKey.stringKey("code.namespace");
    private final CodeAttributesGetter<REQUEST> getter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(CodeAttributesGetter<REQUEST> getter) {
        return new CodeAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private CodeAttributesExtractor(CodeAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        Class<?> cls = this.getter.getCodeClass(request);
        if (cls != null) {
            AttributesExtractorUtil.internalSet(attributes, CODE_NAMESPACE, cls.getName());
        }
        AttributesExtractorUtil.internalSet(attributes, CODE_FUNCTION, this.getter.getMethodName(request));
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

