/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.incubator.semconv.db;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.AttributesBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractorBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.incubator.semconv.db.SqlStatementInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.incubator.semconv.db.SqlStatementSanitizer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.instrumenter.AttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.internal.AttributesExtractorUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.internal.SemconvStability;

public final class SqlClientAttributesExtractor<REQUEST, RESPONSE>
extends DbClientCommonAttributesExtractor<REQUEST, RESPONSE, SqlClientAttributesGetter<REQUEST>> {
    private static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey("db.operation");
    private static final AttributeKey<String> DB_OPERATION_NAME = AttributeKey.stringKey("db.operation.name");
    private static final AttributeKey<String> DB_STATEMENT = AttributeKey.stringKey("db.statement");
    private static final AttributeKey<String> DB_QUERY_TEXT = AttributeKey.stringKey("db.query.text");
    private static final AttributeKey<String> DB_COLLECTION_NAME = AttributeKey.stringKey("db.collection.name");
    private static final String SQL_CALL = "CALL";
    private static final SqlStatementSanitizer sanitizer = SqlStatementSanitizer.create(true);
    private final AttributeKey<String> oldSemconvTableAttribute;
    private final boolean statementSanitizationEnabled;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST> getter) {
        return SqlClientAttributesExtractor.builder(getter).build();
    }

    public static <REQUEST, RESPONSE> SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(SqlClientAttributesGetter<REQUEST> getter) {
        return new SqlClientAttributesExtractorBuilder(getter);
    }

    SqlClientAttributesExtractor(SqlClientAttributesGetter<REQUEST> getter, AttributeKey<String> oldSemconvTableAttribute, boolean statementSanitizationEnabled) {
        super(getter);
        this.oldSemconvTableAttribute = oldSemconvTableAttribute;
        this.statementSanitizationEnabled = statementSanitizationEnabled;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        String rawQueryText = ((SqlClientAttributesGetter)this.getter).getRawQueryText(request);
        SqlStatementInfo sanitizedStatement = sanitizer.sanitize(rawQueryText);
        String operation = sanitizedStatement.getOperation();
        if (SemconvStability.emitStableDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, DB_QUERY_TEXT, this.statementSanitizationEnabled ? sanitizedStatement.getFullStatement() : rawQueryText);
            AttributesExtractorUtil.internalSet(attributes, DB_OPERATION_NAME, operation);
        }
        if (SemconvStability.emitOldDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, DB_STATEMENT, this.statementSanitizationEnabled ? sanitizedStatement.getFullStatement() : rawQueryText);
            AttributesExtractorUtil.internalSet(attributes, DB_OPERATION, operation);
        }
        if (!SQL_CALL.equals(operation)) {
            if (SemconvStability.emitStableDatabaseSemconv()) {
                AttributesExtractorUtil.internalSet(attributes, DB_COLLECTION_NAME, sanitizedStatement.getMainIdentifier());
            }
            if (SemconvStability.emitOldDatabaseSemconv()) {
                AttributesExtractorUtil.internalSet(attributes, this.oldSemconvTableAttribute, sanitizedStatement.getMainIdentifier());
            }
        }
    }
}

