/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.incubator.semconv.messaging;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.metrics.DoubleHistogram;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.metrics.DoubleHistogramBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.metrics.LongCounter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.metrics.LongCounterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.metrics.Meter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context.ContextKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.incubator.semconv.messaging.AutoValue_MessagingConsumerMetrics_State;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.incubator.semconv.messaging.MessagingMetricsAdvice;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.instrumenter.OperationListener;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.instrumenter.OperationMetrics;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.internal.OperationMetricsUtil;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MessagingConsumerMetrics
implements OperationListener {
    private static final double NANOS_PER_S = TimeUnit.SECONDS.toNanos(1L);
    private static final AttributeKey<Long> MESSAGING_BATCH_MESSAGE_COUNT = AttributeKey.longKey("messaging.batch.message_count");
    private static final ContextKey<State> MESSAGING_CONSUMER_METRICS_STATE = ContextKey.named("messaging-consumer-metrics-state");
    private static final Logger logger = Logger.getLogger(MessagingConsumerMetrics.class.getName());
    private final DoubleHistogram receiveDurationHistogram;
    private final LongCounter receiveMessageCount;

    private MessagingConsumerMetrics(Meter meter) {
        DoubleHistogramBuilder durationBuilder = meter.histogramBuilder("messaging.receive.duration").setDescription("Measures the duration of receive operation.").setExplicitBucketBoundariesAdvice(MessagingMetricsAdvice.DURATION_SECONDS_BUCKETS).setUnit("s");
        MessagingMetricsAdvice.applyReceiveDurationAdvice(durationBuilder);
        this.receiveDurationHistogram = durationBuilder.build();
        LongCounterBuilder longCounterBuilder = meter.counterBuilder("messaging.receive.messages").setDescription("Measures the number of received messages.").setUnit("{message}");
        MessagingMetricsAdvice.applyReceiveMessagesAdvice(longCounterBuilder);
        this.receiveMessageCount = longCounterBuilder.build();
    }

    public static OperationMetrics get() {
        return OperationMetricsUtil.create("messaging consumer", MessagingConsumerMetrics::new);
    }

    @Override
    @CanIgnoreReturnValue
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(MESSAGING_CONSUMER_METRICS_STATE, new AutoValue_MessagingConsumerMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        State state = context.get(MESSAGING_CONSUMER_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record consumer receive metrics.", context);
            return;
        }
        Attributes attributes = state.startAttributes().toBuilder().putAll(endAttributes).build();
        this.receiveDurationHistogram.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_S, attributes, context);
        long receiveMessagesCount = MessagingConsumerMetrics.getReceiveMessagesCount(state.startAttributes(), endAttributes);
        this.receiveMessageCount.add(receiveMessagesCount, attributes, context);
    }

    private static long getReceiveMessagesCount(Attributes ... attributesList) {
        for (Attributes attributes : attributesList) {
            Long value = attributes.get(MESSAGING_BATCH_MESSAGE_COUNT);
            if (value == null) continue;
            return value;
        }
        return 1L;
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

